/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.saleorder;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CsLogisticsInfoReqDto;
import com.dtyunxi.tcbj.api.query.ICsLogisticsInfoQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOutDeliveryMessageDto;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OutDeliveryDetailResultDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OutDeliveryResultReqDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="ORDER_SALE_WMS_SEND_BACK_TAG")
public class SaleOrderDeliveredProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaleOrderDeliveredProcessor.class);
    @Resource
    private ISaleOrderApi saleOrderApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ICsLogisticsInfoQueryApi csLogisticsInfoQueryApi;

    public MessageResponse process(MessageVo message) {
        block4: {
            String requestId = RequestId.createReqId();
            MDC.put((String)"yes.req.requestId", (String)requestId);
            ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
            LOGGER.info("[\u63a5\u6536\u5230\u5e93\u5b58\u51fa\u5e93\u7ed3\u679c\u56de\u4f20]\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)message.getData()));
            Object messageData = message.getData();
            try {
                if (!(messageData instanceof CsOutDeliveryMessageDto)) break block4;
                CsOutDeliveryMessageDto csOutDeliveryMessageDto = (CsOutDeliveryMessageDto)messageData;
                OutDeliveryResultReqDto outDeliveryResultReqDto = new OutDeliveryResultReqDto();
                CubeBeanUtils.copyProperties((Object)outDeliveryResultReqDto, (Object)csOutDeliveryMessageDto, (String[])new String[]{"deliveryDetailMessageDtoList"});
                ArrayList deliveryDetailList = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)deliveryDetailList, (Collection)csOutDeliveryMessageDto.getDeliveryDetailMessageDtoList(), OutDeliveryDetailResultDto.class);
                outDeliveryResultReqDto.setDeliveryDetailList((List)deliveryDetailList);
                LOGGER.info("[\u63a5\u6536\u5230\u5e93\u5b58\u51fa\u5e93\u7ed3\u679c\u56de\u4f20]\u8ba2\u5355\uff08saleOrderNo={}\uff09\u5df2\u53d1\u8d27", (Object)csOutDeliveryMessageDto.getOrderNo());
                RestResponse restResponse = this.saleOrderApi.changeDeliveredForOrder(outDeliveryResultReqDto);
                RestResponseHelper.checkOrThrow((RestResponse)restResponse);
                try {
                    this.sendOrderSignMq(csOutDeliveryMessageDto);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
                return MessageResponse.SUCCESS;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return MessageResponse.SUCCESS;
    }

    private void sendOrderSignMq(CsOutDeliveryMessageDto csOutDeliveryMessageDto) {
        if (CollectionUtils.isEmpty((Collection)csOutDeliveryMessageDto.getShippingInfoList())) {
            return;
        }
        CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = (CsWmsShippingInfoReqDto)csOutDeliveryMessageDto.getShippingInfoList().get(0);
        String consignNo = csWmsShippingInfoReqDto.getConsignNo();
        if (StringUtils.isEmpty((CharSequence)consignNo)) {
            return;
        }
        CsLogisticsInfoReqDto csLogisticsInfoReqDto = new CsLogisticsInfoReqDto();
        csLogisticsInfoReqDto.setConsignmentNo(consignNo);
        csLogisticsInfoReqDto.setStatus("4");
        PageInfo csLogisticsInfoRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csLogisticsInfoQueryApi.queryByPage(csLogisticsInfoReqDto));
        LOGGER.info("\u6839\u636e\u6258\u8fd0\u5355\u53f7\u67e5\u8be2\u7269\u6d41\u4fe1\u606f={}", JSON.toJSON((Object)csLogisticsInfoRespDtoPageInfo));
        if (CollectionUtils.isEmpty((Collection)csLogisticsInfoRespDtoPageInfo.getList())) {
            return;
        }
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)csOutDeliveryMessageDto.getOrderNo());
        LOGGER.info("\u51fa\u5e93\u56de\u4f20\u7269\u6d41\u5355\u4fe1\u606f\u5df2\u7b7e\u6536\u72b6\u6001\u9500\u552e\u5355\u7b7e\u6536={}", JSON.toJSON((Object)messageVo));
        this.commonsMqService.sendDelaySingleMessage("ORDER_CONFIRM_RECEIPT", (Object)messageVo, Long.valueOf(120L));
    }
}

