/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.external.inventory;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.service.ExternalService;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.external.eas.ICsEasApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderGenerateDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderBusinessTypeEnum;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="OP_EXTERNAL_TOPIC", tag="PLANNED_ORDER_REFUND_ADD")
public class PlannedOrderRefundAddProcessor
implements IMessageProcessor<Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(PlannedOrderRefundAddProcessor.class);
    @Autowired
    private ExternalService externalService;
    @Autowired
    private ICsEasApi easApi;
    private static final String PURCHASE = "purchase";
    private static final String OUTSOURCE = "outsource";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(Map<String, Object> message) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        String msgStr = JSON.toJSONString(message);
        log.info("\u63a5\u6536\u5230\u65b0\u589e\u91c7\u8d2d/\u59d4\u5916\u9000\u8d27\u8ba1\u5212\u5355\uff1a{}", (Object)msgStr);
        String resultCode = "0";
        String resultMsg = "success";
        try {
            RestResponse<Long> response = this.generateRetreatOrder(message, msgStr);
            resultCode = response.getResultCode();
            resultMsg = response.getResultMsg();
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u91c7\u8d2d/\u59d4\u5916\u9000\u8d27\u8ba1\u5212\u5355\u6d88\u8d39\u5931\u8d25", (Throwable)e);
            resultCode = "100000";
            resultMsg = e.getMessage();
        }
        finally {
            String sendLogId = this.externalService.getSendLogId(message);
            this.externalService.backMsg(sendLogId, resultCode, resultMsg);
        }
        return MessageResponse.SUCCESS;
    }

    private RestResponse<Long> generateRetreatOrder(Map<String, Object> message, String msgStr) {
        CsOutPlannedOrderGenerateReqDto generateReqDto = (CsOutPlannedOrderGenerateReqDto)BeanUtil.copyProperties(message, CsOutPlannedOrderGenerateReqDto.class, (String[])new String[0]);
        String orderType = Convert.toStr((Object)message.get("orderType"));
        boolean isPurchase = PURCHASE.equals(orderType);
        generateReqDto.setOrderType(isPurchase ? CsInventorySourceTypeEnum.PURCHASE_RETREAT.getCode() : CsInventorySourceTypeEnum.OUTSOURCE_RETREAT.getCode());
        generateReqDto.setBusinessType(isPurchase ? CsPlannedOrderBusinessTypeEnum.PURCHASE_RETREAT.getCode() : CsPlannedOrderBusinessTypeEnum.OUTSOURCE_RETREAT.getCode());
        generateReqDto.setOperateFlag("submit");
        List itemReqDtoList = (List)MapUtil.get(message, (Object)"itemDetailList", List.class);
        List itemList = itemReqDtoList.stream().map(items -> {
            CsOutPlannedOrderGenerateDetailReqDto dto = new CsOutPlannedOrderGenerateDetailReqDto();
            BeanUtil.copyProperties((Object)items, (Object)dto, (String[])new String[0]);
            dto.setLongCode(Convert.toStr(items.get("skuCode")));
            dto.setPlanQuantity(Convert.toBigDecimal(items.get("quantity")));
            return dto;
        }).collect(Collectors.toList());
        String warehouseCode = generateReqDto.getWarehouseCode();
        if (StringUtils.isBlank((CharSequence)warehouseCode)) {
            generateReqDto.setWarehouseCode(Convert.toStr(((Map)itemReqDtoList.get(0)).get("warehouseCode")));
        }
        generateReqDto.setItemDetailList(itemList);
        return this.easApi.generateRetreatOrder(generateReqDto);
    }
}

