/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.external.inventory;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.dto.mq.CspClaimAllotPushStatusMqDto;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="OP_EXTERNAL_TOPIC", tag="UPDATE_CSP_CLAIM_ORDER_STATUS")
public class CspClaimAllotPushStatusProcessor
implements IMessageProcessor<String> {
    private static final Logger logger = LoggerFactory.getLogger(CspClaimAllotPushStatusProcessor.class);
    @Resource
    private ICsTransferOrderApi csTransferOrderApi;

    public MessageResponse process(String message) {
        try {
            logger.info("\u6536\u5230CSP\u7d22\u8d54\u8c03\u62e8\u5355\u63a8\u9001\u72b6\u6001\u66f4\u65b0\u6d88\u606f: {}", (Object)message);
            CspClaimAllotPushStatusMqDto mqDto = (CspClaimAllotPushStatusMqDto)JSON.parseObject((String)message, CspClaimAllotPushStatusMqDto.class);
            if (mqDto == null) {
                logger.error("\u89e3\u6790CSP\u7d22\u8d54\u8c03\u62e8\u5355\u63a8\u9001\u72b6\u6001\u66f4\u65b0\u6d88\u606f\u5931\u8d25\uff0c\u6d88\u606f\u5185\u5bb9: {}", (Object)message);
                return MessageResponse.SUCCESS;
            }
            String transferOrderNo = mqDto.getTransferOrderNo();
            String cspPushStatus = mqDto.getCspPushStatus();
            if (transferOrderNo == null || cspPushStatus == null) {
                logger.error("CSP\u7d22\u8d54\u8c03\u62e8\u5355\u63a8\u9001\u72b6\u6001\u66f4\u65b0\u6d88\u606f\u53c2\u6570\u4e0d\u5b8c\u6574\uff0ctransferOrderNo: {}, cspPushStatus: {}", (Object)transferOrderNo, (Object)cspPushStatus);
                return MessageResponse.SUCCESS;
            }
            logger.info("\u5f00\u59cb\u66f4\u65b0\u8c03\u62e8\u5355CSP\u63a8\u9001\u72b6\u6001\uff0c\u8c03\u62e8\u5355\u53f7: {}, \u63a8\u9001\u72b6\u6001: {}", (Object)transferOrderNo, (Object)cspPushStatus);
            RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.updateTransferOrderCspPushStatus(transferOrderNo, cspPushStatus));
            logger.info("\u8c03\u62e8\u5355CSP\u63a8\u9001\u72b6\u6001\u66f4\u65b0\u6210\u529f\uff0c\u8c03\u62e8\u5355\u53f7: {}, \u63a8\u9001\u72b6\u6001: {}", (Object)transferOrderNo, (Object)cspPushStatus);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406CSP\u7d22\u8d54\u8c03\u62e8\u5355\u63a8\u9001\u72b6\u6001\u66f4\u65b0\u6d88\u606f\u5931\u8d25\uff0c\u6d88\u606f\u5185\u5bb9: {}, \u9519\u8bef\u4fe1\u606f: {}", new Object[]{message, e.getMessage(), e});
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }
}

