/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.internal.trade;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.ApportionOrderEnum;
import com.dtyunxi.tcbj.api.query.IDeliveryResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleRefundStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleRefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleRefundQueryApi;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="OP_SALE_EXTERNAL_TOPIC", tag="SALE_ORDER_REFUND_SAP_AUDIT_PROCESS")
public class SaleOrderRefundSapAuditProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger logger = LoggerFactory.getLogger(SaleOrderRefundSapAuditProcessor.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private ISaleRefundQueryApi saleRefundQueryApi;
    @Resource
    private IDeliveryResultOrderQueryApi deliveryResultOrderQueryApi;

    public boolean isDuplicationMessage(String msgId, MessageVo message) {
        return this.cacheService.setIfAbsent(msgId, (Object)1, 60) == false;
    }

    public MessageResponse process(MessageVo message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        logger.info("\u521b\u5efasap\u9500\u552e\u9000\u8d27\u5355\u540e\u89e6\u53d1\u5206\u644a\uff1a{}", (Object)JSON.toJSONString((Object)message));
        Object messageData = message.getData();
        String refundOrderNo = (String)messageData;
        BizSaleRefundRespDto respDto = (BizSaleRefundRespDto)RestResponseHelper.extractData((RestResponse)this.saleRefundQueryApi.queryByRefundNo(refundOrderNo));
        if (StringUtils.isNotBlank((CharSequence)respDto.getSapOrderNo()) && SaleRefundStatusEnum.COMPLETE.getCode().equals(respDto.getRefundStatus())) {
            ArrayList<String> orderNos = new ArrayList<String>();
            orderNos.add(refundOrderNo);
            this.deliveryResultOrderQueryApi.orderDetailApportionBase(orderNos, ApportionOrderEnum.SALE_REFUND.getCode());
        }
        return MessageResponse.SUCCESS;
    }
}

