/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.internal.trade;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.service.ExternalPointService;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderReqDto;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
public class SaleOrderSignProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger logger = LoggerFactory.getLogger(SaleOrderSignProcessor.class);
    @Resource
    private ExternalPointService externalPointService;
    @Resource
    private ICacheService cacheService;

    public boolean isDuplicationMessage(String msgId, MessageVo message) {
        return this.cacheService.setIfAbsent(msgId, (Object)1, 60) == false;
    }

    public MessageResponse process(MessageVo messageVo) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        logger.info("\u9500\u552e\u5355\u7b7e\u6536\u6d88\u606f\u76d1\u542c\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        SaleOrderReqDto saleOrderReqDto = (SaleOrderReqDto)JSON.parseObject((String)messageVo.getData().toString(), SaleOrderReqDto.class);
        try {
            if (Objects.nonNull(saleOrderReqDto.getPlatformOrderId())) {
                this.externalPointService.orderSignToCspPoint(saleOrderReqDto);
            }
        }
        catch (Exception e) {
            logger.error("\u7b7e\u6536\u901a\u77e5csp\u66f4\u65b0\u72b6\u6001\u5f02\u5e38\uff01");
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.externalPointService.updateSaleOrderSignToEas(saleOrderReqDto);
        }
        catch (Exception e) {
            logger.error("\u7b7e\u6536\u901a\u77e5eas\u66f4\u65b0\u72b6\u6001\u5f02\u5e38\uff01");
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.externalPointService.orderSignToYYJPoint(saleOrderReqDto);
        }
        catch (Exception e) {
            logger.error("\u901a\u77e5\u8425\u517b\u5bb6\u66f4\u65b0\u72b6\u6001\u5f02\u5e38\uff01");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

