/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.saleorder;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@MQDesc(tag="ORDER_CONFIRM_RECEIPT")
public class SaleOrderConfirmReceiptProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaleOrderConfirmReceiptProcessor.class);
    @Resource
    private ISaleOrderOptApi saleOrderOptApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;

    public MessageResponse process(MessageVo message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        LOGGER.info("\u5185\u90e8\u8ba2\u5355\u76d1\u542c\u9500\u552e\u8ba2\u5355\u7b7e\u6536{}", (Object)JSON.toJSONString((Object)message.getData()));
        this.confirmReceipt((String)message.getData());
        return MessageResponse.SUCCESS;
    }

    private void confirmReceipt(String orderNo) {
        try {
            SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
            saleOrderQueryReqDto.setSaleOrderNo(orderNo);
            saleOrderQueryReqDto.setOrderStatus(SaleOrderStatusEnum.COMPLETE.getCode());
            List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
            if (CollectionUtils.isEmpty((Collection)saleOrderRespDtos)) {
                LOGGER.info("\u672a\u67e5\u8be2\u5230\u5df2\u5b8c\u6210\u8ba2\u5355");
                return;
            }
            for (SaleOrderRespDto saleOrderRespDto : saleOrderRespDtos) {
                try {
                    LOGGER.info("\u7b7e\u6536\u9500\u552e\u5355[{}]\u7b7e\u6536\u5355\u53f7", (Object)saleOrderRespDto.getSaleOrderNo());
                    RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.confirmReceiptGoods(saleOrderRespDto.getId()));
                }
                catch (Exception e) {
                    LOGGER.info("\u7b7e\u6536\u9500\u552e\u5355[{}]\u7b7e\u6536\u5f02\u5e38", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[\u5185\u90e8\u8ba2\u5355\u7b7e\u6536MQ]\u5f02\u5e38", (Throwable)e);
        }
    }
}

