/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.saleorder;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsSaleRefundInDeliveryMessageDto;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleRefundOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ModifyStatusReqDto;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="ORDER_SALE_REFUND_WMS_SEND_BACK_TAG")
public class SaleRefundProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaleRefundProcessor.class);
    @Resource
    private ISaleRefundOptApi saleRefundOptApi;

    public MessageResponse process(MessageVo message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        LOGGER.info("[\u63a5\u6536\u9500\u552e\u9000\u5165\u5e93\u7ed3\u679c\u6d88\u606f]\uff1a{}", (Object)JSON.toJSONString((Object)message.getData()));
        Object messageData = message.getData();
        if (messageData instanceof CsSaleRefundInDeliveryMessageDto) {
            try {
                CsSaleRefundInDeliveryMessageDto deliveryMessageDto = (CsSaleRefundInDeliveryMessageDto)messageData;
                ModifyStatusReqDto modifyStatusReqDto = new ModifyStatusReqDto();
                modifyStatusReqDto.setSaleRefundNo(deliveryMessageDto.getOrderNo());
                modifyStatusReqDto.setInBoundCount(deliveryMessageDto.getTotalQuantity());
                modifyStatusReqDto.setTypeFlag(deliveryMessageDto.getTypeFlag());
                modifyStatusReqDto.setStatus(deliveryMessageDto.getStatus());
                RestResponse restResponse = this.saleRefundOptApi.modifyStatus(modifyStatusReqDto);
                RestResponseHelper.checkOrThrow((RestResponse)restResponse);
                LOGGER.info("[\u63a5\u6536\u9500\u552e\u9000\u5165\u5e93\u7ed3\u679c\u6d88\u606f]\u6d88\u606f\u6d88\u8d39\u6210\u529f\uff0c\u9500\u552e\u9000\u5355\u53f7\u4e3a\uff1a{}", (Object)deliveryMessageDto.getOrderNo());
                return MessageResponse.SUCCESS;
            }
            catch (Exception e) {
                LOGGER.error("[\u63a5\u6536\u9500\u552e\u9000\u5165\u5e93\u7ed3\u679c\u6d88\u606f]\u5f02\u5e38", (Throwable)e);
                return MessageResponse.ERROR;
            }
        }
        return MessageResponse.SUCCESS;
    }
}

