/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.saleorder;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.vo.ModifySaleOrderDeliveryVo;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ModifyLogicalWarehouseReqDto;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="PUBLISH_TOPIC", tag="INVENTORY_MODIFY_SALE_ORDER_DELIVERY")
public class SaleOrderUpdateLogicInfoProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaleOrderUpdateLogicInfoProcessor.class);
    @Resource
    private ISaleOrderOptApi saleOrderOptApi;

    public MessageResponse process(MessageVo message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        LOGGER.info("\u63a5\u6536\u5e93\u5b58\u4fee\u6539\u53d1\u8d27\u4ed3\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)message.getData()));
        Object messageData = message.getData();
        if (Objects.isNull(messageData)) {
            LOGGER.info("\u63a5\u6536\u7684\u6d88\u606f\u4e3a\u7a7a");
            return MessageResponse.SUCCESS;
        }
        ModifySaleOrderDeliveryVo modifySaleOrderDeliveryVo = (ModifySaleOrderDeliveryVo)JSON.parseObject((String)messageData.toString(), ModifySaleOrderDeliveryVo.class);
        ModifyLogicalWarehouseReqDto logicalWarehouseReqDto = new ModifyLogicalWarehouseReqDto();
        logicalWarehouseReqDto.setSaleOrderNo(modifySaleOrderDeliveryVo.getSaleOrderNo());
        logicalWarehouseReqDto.setLogicalWarehouseId(modifySaleOrderDeliveryVo.getLogicWarehouseId());
        logicalWarehouseReqDto.setLogicalWarehouseCode(modifySaleOrderDeliveryVo.getLogicWarehouseCode());
        logicalWarehouseReqDto.setLogicalWarehouseName(modifySaleOrderDeliveryVo.getLogicWarehouseName());
        logicalWarehouseReqDto.setPhysicsWarehouseId(modifySaleOrderDeliveryVo.getPhysicsWarehouseId());
        logicalWarehouseReqDto.setPhysicsWarehouseCode(modifySaleOrderDeliveryVo.getPhysicsWarehouseCode());
        logicalWarehouseReqDto.setPhysicsWarehouseName(modifySaleOrderDeliveryVo.getPhysicsWarehouseName());
        try {
            LOGGER.info("\u4fee\u6539\u53d1\u8d27\u4ed3\u5e76\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)logicalWarehouseReqDto));
            RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.updateLogicalWarehouseAndDelivery(logicalWarehouseReqDto));
        }
        catch (Exception e) {
            LOGGER.info("\u4fee\u6539\u53d1\u8d27\u4ed3\u5e76\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355\u5f02\u5e38:{}", (Object)e.getMessage());
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

