/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.search.biz.apiimpl.query.impl.inventory;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.search.api.basedto.BaseOrdetReqDto;
import com.dtyunxi.cis.search.api.dto.request.GetNoticeOrderPageParams;
import com.dtyunxi.cis.search.api.dto.request.GetResultOrderPageParams;
import com.dtyunxi.cis.search.api.dto.response.InNoticeOrderVO;
import com.dtyunxi.cis.search.api.dto.response.InResultOrderVO;
import com.dtyunxi.cis.search.api.query.inventory.EsInventoryOrderQueryApi;
import com.dtyunxi.cis.search.api.util.RptUtil;
import com.dtyunxi.cis.search.biz.base.BaseEsService;
import com.dtyunxi.cis.search.biz.util.EsParamUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EsInventoryOrderServiceImpl
extends BaseEsService
implements EsInventoryOrderQueryApi {
    String noticeOrderIndexName = "cs_out_notice_order";
    String resultOrderIndexName = "cs_out_result_order";
    private static final Logger logger = LoggerFactory.getLogger(EsInventoryOrderServiceImpl.class);
    private static final String[] ORDER_NOS = new String[]{"documentNo", "relevanceNo", "wmsOrderNo", "externalOrderNo", "noticeNo"};
    private static final String[] WAREHOUSES = new String[]{"warehouseCode", "warehouseName"};
    private static final String[] IN_WAREHOUSES = new String[]{"inLogicWarehouseCode", "inLogicWarehouseName"};
    private static final String[] OUT_WAREHOUSES = new String[]{"outLogicWarehouseCode", "outLogicWarehouseName"};

    @PostConstruct
    private void init() {
        this.noticeOrderIndexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.noticeOrderIndexName;
        this.resultOrderIndexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.resultOrderIndexName;
    }

    private OSSearchVo initSearchVo(BaseOrdetReqDto reqDto) throws Exception {
        OSSearchVo queryVo = EsParamUtils.newInstance().getSearchVo(reqDto);
        queryVo.setPage(reqDto.getPageNum().intValue());
        queryVo.setPageSize(reqDto.getPageSize().intValue());
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOrderNo())) {
            String[] orderNos = RptUtil.regExSplit((String)reqDto.getOrderNo());
            FilterFieldVo filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String orderNo : orderNos) {
                this.addWildcardFilter(filter, ORDER_NOS, this.wildcard(orderNo));
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOutLogicWarehouseName())) {
            queryVo.addWildcardFilter(OUT_WAREHOUSES, this.wildcard(reqDto.getOutLogicWarehouseName()), LogicalSymbol.OR);
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getInLogicWarehouseName())) {
            queryVo.addWildcardFilter(IN_WAREHOUSES, this.wildcard(reqDto.getInLogicWarehouseName()), LogicalSymbol.OR);
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOrderStatus())) {
            queryVo.addWildcardFilter("orderStatus", "*" + reqDto.getOrderStatus() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getBusinessType())) {
            queryVo.addWildcardFilter("businessType", "*" + reqDto.getBusinessType() + "*");
        }
        String startTime = reqDto.getStartTime();
        String endTime = reqDto.getEndTime();
        if (StringUtils.isNotBlank((CharSequence)endTime) && StringUtils.isNotBlank((CharSequence)startTime)) {
            queryVo.addRangeFilter("createTime", this.beginTimeLong(startTime), this.endTimeLong(endTime));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOrderNo())) {
            String[] orderNos = RptUtil.regExSplit((String)reqDto.getOrderNo());
            FilterFieldVo filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String orderNo : orderNos) {
                this.addWildcardFilter(filter, ORDER_NOS, this.wildcard(orderNo));
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        queryVo.addEqualFilter("orderType", "in");
        queryVo.addSort("createTime", SortOrder.DESC);
        logger.info("\u5165\u5e93\u5355ES[\u67e5\u8be2\u62fc\u63a5\u53c2\u6570]:{}", (Object)JSON.toJSONString((Object)queryVo.getFilterFields()));
        return queryVo;
    }

    public RestResponse<PageInfo<InNoticeOrderVO>> queryNoticeOrderPage(GetNoticeOrderPageParams dto) {
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initSearchVo((BaseOrdetReqDto)dto);
            SearchResultVo searchResultVo = this.searchData(this.noticeOrderIndexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new RestResponse((Object)new PageInfo());
            }
            logger.info("\u5165\u5e93\u901a\u77e5\u5355ES[es\u8fd4\u56deDocValues]:{}", (Object)JSON.toJSONString((Object)searchResultVo.getDocValues()));
            pageInfo = this.searchResultPage(searchResultVo);
            pageInfo.setList(this.baseRowMapper(searchResultVo, InNoticeOrderVO.class));
        }
        catch (Exception e) {
            logger.error("\u5165\u5e93\u901a\u77e5\u5355ES\u67e5\u8be2\u5f02\u5e38\uff1a{}", new Object[]{this.mainExecutor.getDesc(), e.getMessage(), e});
            throw new BizException("\u5165\u5e93\u901a\u77e5\u5355ES\u67e5\u8be2\u5f02\u5e38");
        }
        return new RestResponse((Object)pageInfo);
    }

    public RestResponse<PageInfo<InResultOrderVO>> queryResultOrderPage(GetResultOrderPageParams dto) {
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initSearchVo((BaseOrdetReqDto)dto);
            SearchResultVo searchResultVo = this.searchData(this.resultOrderIndexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new RestResponse((Object)new PageInfo());
            }
            logger.info("\u5165\u5e93\u7ed3\u679c\u5355ES[es\u8fd4\u56deDocValues]:{}", (Object)JSON.toJSONString((Object)searchResultVo.getDocValues()));
            pageInfo = this.searchResultPage(searchResultVo);
            pageInfo.setList(this.baseRowMapper(searchResultVo, InResultOrderVO.class));
        }
        catch (Exception e) {
            logger.error("\u5165\u5e93\u7ed3\u679c\u5355ES\u67e5\u8be2\u5f02\u5e38\uff1a{}", new Object[]{this.mainExecutor.getDesc(), e.getMessage(), e});
            throw new BizException("\u5165\u5e93\u7ed3\u679c\u5355ES\u67e5\u8be2\u5f02\u5e38");
        }
        return new RestResponse((Object)pageInfo);
    }
}

