/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.search.biz.apiimpl.query.impl.inventory;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.search.api.dto.request.EsChannelInventoryListPageParams;
import com.dtyunxi.cis.search.api.dto.response.EsChannelInventoryVO;
import com.dtyunxi.cis.search.api.query.inventory.EsChannelInventoryQueryApi;
import com.dtyunxi.cis.search.biz.anno.ExecutorHandler;
import com.dtyunxi.cis.search.biz.base.BaseEsService;
import com.dtyunxi.cis.search.biz.constant.ExecutorEnum;
import com.dtyunxi.cis.search.biz.util.EsParamUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.huieryun.opensearch.vo.SortFieldVo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@ExecutorHandler(executorName={ExecutorEnum.SH_CHANNEL_INVENTORY})
public class EsChannelInventoryQueryServiceImpl
extends BaseEsService
implements EsChannelInventoryQueryApi {
    private static final Logger log = LoggerFactory.getLogger(EsChannelInventoryQueryServiceImpl.class);

    private OSSearchVo initSearchVo(EsChannelInventoryListPageParams reqDto) throws Exception {
        OSSearchVo queryVo = EsParamUtils.newInstance().getSearchVo(reqDto);
        if (Objects.nonNull(reqDto.getPositiveBalance())) {
            if (reqDto.getPositiveBalance() == 1) {
                queryVo.addRangeFilter("balance", "1", String.valueOf(Integer.MAX_VALUE));
            } else if (reqDto.getPositiveBalance() == 0) {
                queryVo.addRangeFilter("balance", String.valueOf(Integer.MIN_VALUE), "0");
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getSkuCodeList())) {
            queryVo.addInFilter("itemLongCode", reqDto.getSkuCodeList().toArray(new String[0]));
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getWarehouseCodeList())) {
            queryVo.addInFilter("warehouseCode", reqDto.getWarehouseCodeList().toArray(new String[0]));
        }
        log.info("{}ES[\u67e5\u8be2\u62fc\u63a5\u53c2\u6570]:{}", (Object)this.mainExecutor.getDesc(), (Object)JSON.toJSONString((Object)queryVo.getFilterFields()));
        return queryVo;
    }

    public RestResponse<PageInfo<EsChannelInventoryVO>> queryChannelInventoryListPage(EsChannelInventoryListPageParams dto) {
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initSearchVo(dto);
            queryVo.setPage(dto.getPageNum().intValue());
            queryVo.setPageSize(dto.getPageSize().intValue());
            ArrayList sortFields = Lists.newArrayList();
            sortFields.add(SortFieldVo.build((String)"changeTime", (SortOrder)SortOrder.DESC));
            sortFields.add(SortFieldVo.build((String)"id", (SortOrder)SortOrder.DESC));
            queryVo.setSortFields((List)sortFields);
            SearchResultVo searchResultVo = this.searchData(this.indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new RestResponse((Object)new PageInfo());
            }
            pageInfo = this.searchResultPage(searchResultVo);
            pageInfo.setList(this.baseRowMapper(searchResultVo, EsChannelInventoryVO.class));
        }
        catch (Exception e) {
            log.error("{}ES\u67e5\u8be2\u5f02\u5e38\uff1a{}", new Object[]{this.mainExecutor.getDesc(), e.getMessage(), e});
            throw new BizException(this.mainExecutor.getDesc() + "ES\u67e5\u8be2\u5f02\u5e38");
        }
        return new RestResponse((Object)pageInfo);
    }
}

