/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.search.biz.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class AddressUtil {
    private static final String REGEX = "(?<province>[^\u7701]+\u81ea\u6cbb\u533a|.*?\u7701|.*?\u884c\u653f\u533a|.*?\u5e02)(?<city>[^\u5e02]+\u81ea\u6cbb\u5dde|.*?\u5730\u533a|.*?\u884c\u653f\u5355\u4f4d|.+\u76df|\u5e02\u8f96\u533a|.*?\u5e02|.*?\u53bf)(?<county>[^\u53bf]+\u53bf|.+\u533a|.+\u5e02|.+\u65d7|.+\u6d77\u57df|.+\u5c9b)?(?<town>[^\u533a]+\u533a|.+\u9547)?(?<village>.*)";

    public static Map<String, String> addressResolution(String address) {
        LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)address)) {
            return row;
        }
        address = address.replaceAll(" ", "");
        Matcher m = Pattern.compile(REGEX).matcher(address);
        String province = null;
        String city = null;
        String county = null;
        String town = null;
        String village = null;
        while (m.find()) {
            province = m.group("province");
            row.put("province", province == null ? "" : province.trim());
            city = m.group("city");
            row.put("city", city == null ? "" : city.trim());
            county = m.group("county");
            row.put("county", county == null ? "" : county.trim());
            town = m.group("town");
            row.put("town", town == null ? "" : town.trim());
            village = m.group("village");
            row.put("village", village == null ? "" : village.trim());
        }
        return row;
    }

    public static void main(String[] args) {
        System.out.println(AddressUtil.addressResolution("\u6e56\u5317\u7701\u6b66\u6c49\u5e02\u6d2a\u5c71\u533a"));
        System.out.println(AddressUtil.addressResolution("\u6e56\u5317\u7701\u6069\u65bd\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde\u6069\u65bd\u5e02123\u53f7"));
        System.out.println(AddressUtil.addressResolution("\u5317\u4eac\u5e02\u5e02\u8f96\u533a\u671d\u9633\u533a"));
        System.out.println(AddressUtil.addressResolution("\u5185\u8499\u53e4\u81ea\u6cbb\u533a\u5174\u5b89\u76df\u79d1\u5c14\u6c81\u53f3\u7ffc\u524d\u65d7"));
        System.out.println(AddressUtil.addressResolution("\u897f\u85cf\u81ea\u6cbb\u533a\u65e5\u5580\u5219\u5730\u533a\u65e5\u5580\u5219\u5e02"));
        System.out.println(AddressUtil.addressResolution("\u6d77\u5357\u7701\u7701\u76f4\u8f96\u53bf\u7ea7\u884c\u653f\u5355\u4f4d\u4e2d\u6c99\u7fa4\u5c9b\u7684\u5c9b\u7901\u53ca\u5176\u6d77\u57df"));
    }
}

