/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle.config;

import com.dtyunxi.cube.starter.bundle.annotate.CubeWeakDependency;
import com.dtyunxi.cube.starter.bundle.dto.WeakReferenceDto;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.ReflectionUtils;

public class WeakReferenceBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
PriorityOrdered {
    private static final Logger logger = LoggerFactory.getLogger(WeakReferenceBeanPostProcessor.class);
    private static final Map<Class<?>, WeakReferenceDto> bean2Api = new ConcurrentHashMap();
    private static final Map<String, List<Class<?>>> api2Bean = new ConcurrentHashMap();
    private static final Map<String, List<String>> bundle2Api = new ConcurrentHashMap<String, List<String>>();
    private BeanFactory beanFactory;

    public Object postProcessAfterInitialization(@Nonnull Object bean, String beanName) throws BeansException {
        Class beanClass = AopProxyUtils.ultimateTargetClass((Object)bean);
        Object target = AopUtils.isAopProxy((Object)bean) ? AopProxyUtils.getSingletonTarget((Object)bean) : bean;
        ArrayList<WeakReferenceDto.WeakReferenceFieldDto> weakReferenceFieldDtos = new ArrayList<WeakReferenceDto.WeakReferenceFieldDto>();
        ReflectionUtils.doWithFields((Class)beanClass, field -> {
            WeakReferenceDto.WeakReferenceFieldDto weakField = new WeakReferenceDto.WeakReferenceFieldDto();
            Class<?> fieldClazz = field.getType();
            weakField.setField(field);
            weakField.setFieldClazz(fieldClazz);
            weakField.setFieldSystemProxy(this.beanFactory.getBean(fieldClazz));
            weakReferenceFieldDtos.add(weakField);
            List<Class<?>> beanClassList = api2Bean.get(fieldClazz.getCanonicalName());
            if (null == beanClassList) {
                beanClassList = new ArrayList();
                beanClassList.add(beanClass);
                api2Bean.put(fieldClazz.getCanonicalName(), beanClassList);
            } else {
                beanClassList.add(beanClass);
            }
        }, field -> field.isAnnotationPresent(CubeWeakDependency.class));
        if (weakReferenceFieldDtos.size() > 0) {
            WeakReferenceDto weakReferenceDto = new WeakReferenceDto();
            weakReferenceDto.setBeanClass(beanClass);
            weakReferenceDto.setBeanName(beanName);
            weakReferenceDto.setTarget(target);
            weakReferenceDto.setWeakReferenceFieldDtos(weakReferenceFieldDtos);
            bean2Api.put(beanClass, weakReferenceDto);
        }
        return bean;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public static Map<Class<?>, WeakReferenceDto> getBean2Api() {
        return bean2Api;
    }

    public static Map<String, List<Class<?>>> getApi2Bean() {
        return api2Bean;
    }

    public static Map<String, List<String>> getBundle2Api() {
        return bundle2Api;
    }

    public static WeakReferenceDto.WeakReferenceFieldDto getWeakReferenceFieldDto(String apiName, Class<?> beanClazz) {
        if (StringUtils.isBlank((CharSequence)apiName) || null == beanClazz) {
            return null;
        }
        WeakReferenceDto weakReferenceDto = bean2Api.get(beanClazz);
        if (null == weakReferenceDto) {
            return null;
        }
        return weakReferenceDto.getWeakReferenceFieldDtos().stream().filter(fieldDto -> fieldDto.getFieldClazz().getCanonicalName().equals(apiName)).findFirst().orElse(null);
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

