/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.cube.starter.bundle.config.WeakReferenceBeanPostProcessor;
import com.dtyunxi.cube.starter.bundle.dto.WeakReferenceDto;
import com.dtyunxi.cube.starter.bundle.runner.BundleLoadedInjectRunner;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.BundleLoadedNotifyDto;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@MQDesc(topic="${dtyunxi.bundle.mq.app_bundle_relate.topic:APP_BUNDLE_RELATION_TOPIC}", tag="APP_BUNDLE_RELATION_TAG", msgType="publish")
public class BundleLoadedNotiyListener
implements IMessageProcessor<BundleLoadedNotifyDto> {
    private static final Logger logger = LoggerFactory.getLogger(BundleLoadedNotiyListener.class);
    @Resource
    private BundleLoadedInjectRunner runner;

    public MessageResponse process(BundleLoadedNotifyDto message) {
        logger.info("\u63a5\u6536\u5230\u529f\u80fd\u5305\u52a0\u8f7d\u7684\u53d8\u66f4\u4e8b\u4ef6\uff1a" + JSON.toJSONString((Object)message));
        Map<String, List<String>> bundle2Api = WeakReferenceBeanPostProcessor.getBundle2Api();
        Map<String, List<Class<?>>> api2Bean = WeakReferenceBeanPostProcessor.getApi2Bean();
        Map<Class<?>, WeakReferenceDto> bean2Api = WeakReferenceBeanPostProcessor.getBean2Api();
        Map bundleLoadedMap = message.getBundleLoadedMap();
        if (MapUtils.isEmpty((Map)bundleLoadedMap)) {
            return MessageResponse.SUCCESS;
        }
        for (Map.Entry entry : bundleLoadedMap.entrySet()) {
            List<String> apiList = bundle2Api.get(entry.getKey());
            if (CollectionUtils.isEmpty(apiList)) {
                logger.info("\u529f\u80fd\u5305\u5bf9\u5e94\u7684\u5f31\u4f9d\u8d56api\u4e0d\u5b58\u5728\uff0cbundleCode\uff1a{}", entry.getKey());
                continue;
            }
            for (String api : apiList) {
                List<Class<?>> beanClassList = api2Bean.get(api);
                if (CollectionUtils.isEmpty(beanClassList)) continue;
                for (Class<?> beanClass : beanClassList) {
                    WeakReferenceDto.WeakReferenceFieldDto weakFieldDto = WeakReferenceBeanPostProcessor.getWeakReferenceFieldDto(api, beanClass);
                    if (null == weakFieldDto) {
                        logger.info("API\u627e\u4e0d\u5230\u88ab\u5f15\u7528\u4fe1\u606f\uff0capi\uff1a{}", (Object)api);
                        continue;
                    }
                    if (weakFieldDto.getAppBundle().booleanValue() || weakFieldDto.getBundleLoaded().equals(entry.getValue())) continue;
                    weakFieldDto.setBundleLoaded((Boolean)entry.getValue());
                    this.runner.modifyBeanDefinition(beanClass, weakFieldDto);
                }
            }
        }
        return MessageResponse.SUCCESS;
    }
}

