/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle.rest;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.starter.bundle.api.PullBundleDescriptionApi;
import com.dtyunxi.cube.starter.bundle.dto.BundleBaseDto;
import com.dtyunxi.cube.starter.bundle.dto.request.BundleDescReqDto;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleApisRespDto;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleBaseSettingRespDto;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleDescRespDto;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleDtosRespDto;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleEosRespDto;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleFlowsRespDto;
import com.dtyunxi.cube.starter.bundle.reader.BundleApiReader;
import com.dtyunxi.cube.starter.bundle.reader.BundleBaseReader;
import com.dtyunxi.cube.starter.bundle.reader.BundleDescReader;
import com.dtyunxi.cube.starter.bundle.reader.BundleDtoReader;
import com.dtyunxi.cube.starter.bundle.reader.BundleEoReader;
import com.dtyunxi.cube.starter.bundle.reader.BundleFlowReader;
import com.dtyunxi.cube.starter.bundle.reader.BundleSettingReader;
import com.dtyunxi.cube.starter.bundle.runner.ApiEnhanceSenderRunner;
import com.dtyunxi.rest.RestResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/bundle/description/"})
public class PullBundleDescriptionRest
implements PullBundleDescriptionApi {
    private static final Logger logger = LoggerFactory.getLogger(PullBundleDescriptionRest.class);
    @Resource
    private ApiEnhanceSenderRunner apiEnhanceSenderRunner;
    @Value(value="&{spring.application.name:UNKNOWN}")
    String serviceId;

    public RestResponse<String> serviceId() {
        return new RestResponse((Object)this.serviceId);
    }

    public RestResponse<List<BundleDescRespDto>> list(BundleDescReqDto bundleDescriptionReqDto) {
        return new RestResponse(new ArrayList(new BundleDescReader().process(false, false, false, false, false).values()));
    }

    public RestResponse<List<BundleBaseSettingRespDto>> basicList(BundleDescReqDto bundleDescriptionReqDto) {
        ArrayList values = new ArrayList(new BundleBaseReader().process(Boolean.valueOf(false)).values());
        Map<String, String> artifactId2GroupIdMap = values.stream().collect(Collectors.toMap(BundleBaseDto::getArtifactId, BundleBaseDto::getGroupId));
        Collection bundleSettingValues = new BundleSettingReader().process(Boolean.valueOf(false)).values();
        bundleSettingValues.forEach(bundleBaseSettingRespDto -> {
            String artifactId = bundleBaseSettingRespDto.getArtifactId();
            String groupId = bundleBaseSettingRespDto.getGroupId();
            if (StrUtil.isNotBlank((CharSequence)artifactId) && StrUtil.isNotBlank((CharSequence)groupId)) {
                String baseGroupId = (String)artifactId2GroupIdMap.get(artifactId);
                if (ObjectUtil.equal((Object)groupId, (Object)baseGroupId)) {
                    values.add(bundleBaseSettingRespDto);
                }
            } else {
                logger.debug("\u529f\u80fd\u5305\u57fa\u7840\u4fe1\u606f\u4e3a\u7a7a\uff1a{}", (Object)JSON.toJSONString((Object)bundleBaseSettingRespDto));
            }
        });
        return new RestResponse(new ArrayList(values));
    }

    public RestResponse<List<BundleApisRespDto>> apiList(BundleDescReqDto bundleDescriptionReqDto) {
        Collection values = new BundleApiReader().process(Boolean.valueOf(false)).values();
        values.forEach(this::sendApiDetailEnhance);
        return new RestResponse(new ArrayList(values));
    }

    public RestResponse<List<BundleDtosRespDto>> dtoList(BundleDescReqDto bundleDescriptionReqDto) {
        Collection values = new BundleDtoReader().process(Boolean.valueOf(false)).values();
        return new RestResponse(new ArrayList(values));
    }

    public RestResponse<List<BundleEosRespDto>> eoList(BundleDescReqDto bundleDescriptionReqDto) {
        Collection values = new BundleEoReader().process(Boolean.valueOf(false)).values();
        return new RestResponse(new ArrayList(values));
    }

    public RestResponse<List<BundleFlowsRespDto>> flowList(BundleDescReqDto bundleDescriptionReqDto) {
        Collection values = new BundleFlowReader().process(Boolean.valueOf(false)).values();
        return new RestResponse(new ArrayList(values));
    }

    private void sendApiDetailEnhance(BundleApisRespDto bundleApisRespDto) {
        if (null == bundleApisRespDto) {
            logger.info("\u529f\u80fd\u5305\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u53d1\u9001MQ\u5904\u7406");
            return;
        }
        this.apiEnhanceSenderRunner.doSendApiEnhanceDetail(bundleApisRespDto.getArtifactId(), bundleApisRespDto.getArtifactId(), bundleApisRespDto.getApis());
    }
}

