/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle.runner;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleApiRespDto;
import com.dtyunxi.cube.starter.bundle.dto.response.enhance.BundleApiEnhanceDto;
import com.dtyunxi.cube.starter.bundle.service.BundleApiEnhanceService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class ApiEnhanceSenderRunner {
    private static final Logger logger = LoggerFactory.getLogger(ApiEnhanceSenderRunner.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private BundleApiEnhanceService bundleApiEnhanceService;
    private boolean notify = true;
    private static final String NULL_API_ENHANCE_MQ_TOPIC = "NULL_API_ENHANCE_MQ_TOPIC";
    private static final String NULL_API_ENHANCE_MQ_TAG = "NULL_API_ENHANCE_MQ_TAG";
    @Value(value="${dtyunxi.yundt.cube.bundle.mq.topic.reportApiInfo:NULL_API_ENHANCE_MQ_TOPIC}")
    private String API_ENHANCE_MQ_TOPIC;
    @Value(value="${dtyunxi.yundt.cube.bundle.mq.tag.reportApiInfo:NULL_API_ENHANCE_MQ_TAG}")
    private String API_ENHANCE_MQ_TAG;

    public ApiEnhanceSenderRunner(boolean notify) {
        this.notify = notify;
    }

    public void doSendApiEnhanceDetail(String name, String applicationName, List<BundleApiRespDto> apis) {
        if (!this.notify || this.API_ENHANCE_MQ_TOPIC.equals(NULL_API_ENHANCE_MQ_TOPIC) || this.API_ENHANCE_MQ_TAG.equals(NULL_API_ENHANCE_MQ_TAG)) {
            logger.info("\u529f\u80fd\u5305api\u4fe1\u606f\u80fd\u529b\u589e\u5f3a\u672a\u5f00\u542f\u6216\u672a\u914d\u7f6eMQ\u7684topic\u3001tag");
        } else {
            logger.info("\u5f00\u59cb\u8f6c\u6362\u529f\u80fd\u5305api\u4fe1\u606f");
            BundleApiEnhanceDto bundleApiEnhanceDto = this.bundleApiEnhanceService.processApiEnhance(name, applicationName, apis);
            logger.info("\u5f00\u59cb\u53d1\u9001\u529f\u80fd\u5305api\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)bundleApiEnhanceDto));
            this.commonsMqService.sendSingleMessageAsync(this.API_ENHANCE_MQ_TOPIC, this.API_ENHANCE_MQ_TAG, (Object)bundleApiEnhanceDto);
        }
    }
}

