/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle.runner;

import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.starter.bundle.dto.BundleDescDto;
import com.dtyunxi.cube.starter.bundle.dto.response.ChartAndHurdleRespDto;
import com.dtyunxi.cube.starter.bundle.service.PullChartAndHurdleService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.Pair;
import com.dtyunxi.net.LocalIpAddress;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;

public class BocSenderRunner
implements CommandLineRunner,
EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(BocSenderRunner.class);
    private ICommonsMqService commonsMqService;
    private String serviceId;
    private int port;
    private Environment environment;
    PullChartAndHurdleService pullChartAndHurdleService;

    public BocSenderRunner(ICommonsMqService commonsMqService, int port, String serviceId, PullChartAndHurdleService pullChartAndHurdleService) {
        this.commonsMqService = commonsMqService;
        this.serviceId = serviceId;
        this.port = port;
        this.pullChartAndHurdleService = pullChartAndHurdleService;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void run(String ... args) throws Exception {
        BundleDescDto<ChartAndHurdleRespDto> bundleDescDto = this.generateBundleDescDto();
        bundleDescDto.setContent(this.pullChartAndHurdleService.loadChartsAndHurdles().getData());
        this.commonsMqService.sendSingleMessageAsync(this.environment.resolvePlaceholders("${boc.chart.hurdle.topic:SINGLE_TOPIC}"), this.environment.resolvePlaceholders("${boc.chart.hurdle.topic:BOC_CHART_HURDLE_TAG}"), bundleDescDto);
    }

    protected BundleDescDto<ChartAndHurdleRespDto> generateBundleDescDto() throws UnknownHostException {
        BundleDescDto bundleDescDto = new BundleDescDto();
        bundleDescDto.setIp(LocalIpAddress.resolveLocalIp());
        bundleDescDto.setPort(this.port);
        bundleDescDto.setServiceId(this.serviceId);
        Pair<String, Date> pair = this.parseAppJar();
        bundleDescDto.setApplicationVersion((String)pair.key);
        bundleDescDto.setApplicationCreateTime((Date)pair.value);
        return bundleDescDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pair<String, Date> parseAppJar() {
        String jarFilePath = ClassUtils.getDefaultClassLoader().getResource("").getPath().replace("!/BOOT-INF/classes!/", "");
        logger.info("jarFilePath={}", (Object)jarFilePath);
        if (jarFilePath.startsWith("file")) {
            jarFilePath = jarFilePath.substring("file".length() + 1);
        }
        JarFile jarFile = null;
        InputStream in = null;
        String version = null;
        String strBuildTime = null;
        try {
            Manifest manifest;
            Attributes maniAttributes;
            JarEntry entry;
            if (jarFilePath.endsWith(".jar") && null != (entry = (jarFile = new JarFile(jarFilePath)).getJarEntry("META-INF/MANIFEST.MF")) && null != (maniAttributes = (manifest = new Manifest(in = jarFile.getInputStream(entry))).getMainAttributes())) {
                strBuildTime = maniAttributes.getValue("git-build-time");
                if (StringUtils.isBlank((CharSequence)strBuildTime)) {
                    strBuildTime = maniAttributes.getValue("git-cm-time");
                }
                if (StringUtils.isBlank((CharSequence)strBuildTime)) {
                    logger.error("MANIFEST.MF\u4e2d\u627e\u4e0d\u5230\u6253\u5305\u65f6\u95f4{}\u6216\u8005{}", (Object)"git-build-time", (Object)"git-cm-time");
                }
                if (StringUtils.isBlank((CharSequence)(version = maniAttributes.getValue("version")))) {
                    logger.error("MANIFEST.MF\u4e2d\u627e\u4e0d\u5230\u7248\u672c\u53f7{}", (Object)"version");
                }
                logger.info("buildTime={}, version={}", (Object)strBuildTime, (Object)version);
            }
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
                if (null != jarFile) {
                    jarFile.close();
                }
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
        }
        return new Pair(version, (Object)this.formatBuildTime(strBuildTime));
    }

    protected Date formatBuildTime(String strSrcTime) {
        if (StringUtils.isBlank((CharSequence)strSrcTime)) {
            return null;
        }
        return DateUtil.parseDate((String)strSrcTime, (String)"yyyy-MM-dd'T'HH:mm:ssZ");
    }
}

