/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle.service;

import com.dtyunxi.cube.starter.bundle.dto.response.BundleApiRespDto;
import com.dtyunxi.cube.starter.bundle.dto.response.enhance.BundleApiEnhanceDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleApiEnhanceService {
    private Logger logger = LoggerFactory.getLogger(BundleApiEnhanceService.class);

    public BundleApiEnhanceDto processApiEnhance(String name, String applicationName, List<BundleApiRespDto> apis) {
        BundleApiEnhanceDto bundleApiEnhanceDto = new BundleApiEnhanceDto();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (!name.matches("[\\u4e00-\\u9fa5]+")) {
                name = null;
            }
            bundleApiEnhanceDto.setServiceName(name);
        }
        bundleApiEnhanceDto.setServiceKey(applicationName);
        if (CollectionUtils.isEmpty(apis)) {
            this.logger.info("\u529f\u80fd\u5305\u7684API\u6570\u636e\u4e3a\u7a7a");
            return bundleApiEnhanceDto;
        }
        ArrayList apiResults = new ArrayList();
        for (BundleApiRespDto bundleApiRespDto : apis) {
            apiResults.addAll(bundleApiRespDto.getPaths());
        }
        ArrayList<BundleApiEnhanceDto.ApiEnhanceDto> apiList = new ArrayList<BundleApiEnhanceDto.ApiEnhanceDto>();
        for (BundleApiRespDto.Path path : apiResults) {
            List<String> results;
            BundleApiEnhanceDto.ApiEnhanceDto apiEnhanceDto = new BundleApiEnhanceDto.ApiEnhanceDto();
            apiEnhanceDto.setPath(path.getPath());
            apiEnhanceDto.setType(path.getMethod());
            List requestParams = path.getRequestParams();
            ArrayList<String> reqParams = new ArrayList<String>();
            if (CollectionUtils.isNotEmpty((Collection)requestParams)) {
                for (BundleApiRespDto.Path.ApiParam requestParam : requestParams) {
                    results = CollectionUtils.isEmpty((Collection)requestParam.getProperties()) ? this.getInputOutputProperties(requestParam.getName(), requestParam.getProperties()) : this.getInputOutputProperties(null, requestParam.getProperties());
                    if (!CollectionUtils.isNotEmpty(results)) continue;
                    reqParams.addAll(results);
                }
            }
            apiEnhanceDto.setInput(reqParams);
            ArrayList<String> respParams = new ArrayList<String>();
            BundleApiRespDto.Path.ApiParam responseParam = path.getResponseParam();
            if (null != responseParam && StringUtils.isNotBlank((CharSequence)responseParam.getName()) && !responseParam.getName().contains("Void") && CollectionUtils.isNotEmpty(results = CollectionUtils.isEmpty((Collection)responseParam.getProperties()) ? this.getInputOutputProperties(responseParam.getName(), responseParam.getProperties()) : this.getInputOutputProperties(null, responseParam.getProperties()))) {
                respParams.addAll(results);
            }
            apiEnhanceDto.setOutput(respParams);
            apiList.add(apiEnhanceDto);
        }
        bundleApiEnhanceDto.setApiList(apiList);
        return bundleApiEnhanceDto;
    }

    private List<String> getInputOutputProperties(String parentPropertyName, List<BundleApiRespDto.Path.ApiParam.Property> properties) {
        ArrayList<String> reqParams = new ArrayList<String>();
        if (CollectionUtils.isEmpty(properties)) {
            String name;
            if (StringUtils.isNotBlank((CharSequence)parentPropertyName) && StringUtils.isNotBlank((CharSequence)(name = this.cutPrefix(parentPropertyName)))) {
                reqParams.add(name);
            }
        } else {
            for (BundleApiRespDto.Path.ApiParam.Property p : properties) {
                List childrenProprety = p.getProperties();
                if (CollectionUtils.isEmpty((Collection)childrenProprety)) {
                    String name = this.cutPrefix(p.getName());
                    if (StringUtils.isBlank((CharSequence)name)) continue;
                    reqParams.add(StringUtils.isBlank((CharSequence)parentPropertyName) ? name : parentPropertyName + "." + name);
                    continue;
                }
                List<Object> childrenReqParam = new ArrayList();
                if (p.getType().contains("List") || p.getType().contains("Map") || p.getType().contains("Set")) {
                    List genericityProperties = p.getProperties();
                    if (CollectionUtils.isNotEmpty((Collection)genericityProperties)) {
                        for (BundleApiRespDto.Path.ApiParam.Property property : genericityProperties) {
                            String genericityType = property.getType();
                            if (!StringUtils.isNotBlank((CharSequence)genericityType) || !genericityType.contains("$")) continue;
                            String parentName = genericityType.substring(genericityType.lastIndexOf("$") + 1);
                            childrenReqParam = this.getInputOutputProperties(parentName, property.getProperties());
                        }
                    } else {
                        reqParams.add(p.getName());
                    }
                } else {
                    String name = p.getName();
                    if (StringUtils.isNotBlank((CharSequence)name) && !name.matches("[^\\u4e00-\\u9fa5]+")) {
                        name = null;
                    }
                    childrenReqParam = this.getInputOutputProperties(name, childrenProprety);
                }
                reqParams.addAll(childrenReqParam);
            }
        }
        return reqParams;
    }

    private String cutPrefix(String name) {
        String withoutRestResponseStr;
        if (StringUtils.isNotBlank((CharSequence)name) && StringUtils.isNotBlank((CharSequence)(withoutRestResponseStr = name.replace("com.dtyunxi.rest.RestResponse", "").replace("<", "").replace(">", "")))) {
            return withoutRestResponseStr.substring(withoutRestResponseStr.lastIndexOf(".") + 1);
        }
        return null;
    }
}

