/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.bundle.utils;

import com.dtyunxi.cube.starter.bundle.utils.MyMapUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class DependenceProcessUtils {
    public static void processWaitingMap(Map<String, List<String>> dependenceMap, Map<String, String> waitMap, IProcess process) {
        if (waitMap.isEmpty()) {
            return;
        }
        HashMap newWaitMap = Maps.newHashMap();
        waitMap.forEach((bundleKey, path) -> {
            if (CollectionUtils.isEmpty((Collection)((Collection)dependenceMap.get(bundleKey)))) {
                process.run(bundleKey);
                dependenceMap.values().forEach(list -> list.remove(bundleKey));
            } else if (waitMap.containsKey(bundleKey)) {
                process.wait(new Object[]{waitMap, bundleKey, path});
            }
        });
        DependenceProcessUtils.processWaitingMap(dependenceMap, newWaitMap, process);
    }

    public static void main(String[] args) {
        HashMap dependenceMap = Maps.newHashMap();
        MyMapUtils.append2ListMap("a", dependenceMap, "b");
        MyMapUtils.append2ListMap("a", dependenceMap, "c");
        MyMapUtils.append2ListMap("a", dependenceMap, "d");
        MyMapUtils.append2ListMap("b", dependenceMap, "c");
        MyMapUtils.append2ListMap("b", dependenceMap, "e");
        MyMapUtils.append2ListMap("b", dependenceMap, "f");
        MyMapUtils.append2ListMap("c", dependenceMap, "f");
        dependenceMap.put("d", Lists.newArrayList());
        dependenceMap.put("e", Lists.newArrayList());
        dependenceMap.put("f", Lists.newArrayList());
        System.out.println(dependenceMap);
        String[] keys = new String[]{"a", "b", "c", "d", "e", "f", "g"};
        IProcess<String, Object[]> process = new IProcess<String, Object[]>(){

            @Override
            public void run(String bundleKey) {
                System.out.println("\u65e0\u4f9d\u8d56\uff0c\u76f4\u63a5\u6267\u884c\uff1a" + bundleKey);
            }

            @Override
            public void wait(Object[] objects) {
                Map waitMap = (Map)objects[0];
                waitMap.put((String)objects[1], (String)objects[2]);
            }
        };
        HashMap waitMap = Maps.newHashMap();
        for (String bundleKey : keys) {
            if (CollectionUtils.isEmpty((Collection)((Collection)dependenceMap.get(bundleKey)))) {
                process.run(bundleKey);
                dependenceMap.values().forEach(list -> list.remove(bundleKey));
                continue;
            }
            process.wait(new Object[]{waitMap, bundleKey, ""});
        }
        DependenceProcessUtils.processWaitingMap(dependenceMap, waitMap, process);
        System.out.println(dependenceMap);
    }

    public static interface IProcess<RUN_PARAM, WAIT_PARAM> {
        public void run(RUN_PARAM var1);

        public void wait(WAIT_PARAM var1);
    }
}

