/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.data.limit.config;

import com.dtyunxi.cube.starter.data.limit.feign.FeignClientContextDataLimitFilter;
import com.dtyunxi.cube.starter.data.limit.feign.IDataLimitRuleQueryApi;
import com.dtyunxi.cube.starter.data.limit.intercept.DataLimitInterceptor;
import com.dtyunxi.cube.starter.data.limit.service.impl.DataLimitRuleQueryServiceImpl;
import com.dtyunxi.cube.starter.data.limit.service.impl.MetaDataQueryServiceImpl;
import com.dtyunxi.cube.starter.data.limit.util.MetaDataHolder;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.datalimit.aop.DataLimitAspect;
import com.dtyunxi.huieryun.datalimit.intercept.DataLimitIntercept;
import com.dtyunxi.huieryun.datalimit.service.IDataLimitRuleQueryService;
import com.dtyunxi.huieryun.datalimit.service.IMetaDataQueryService;
import com.dtyunxi.huieryun.datalimit.utils.DataLimitRuleHandler;
import com.dtyunxi.huieryun.datalimit.utils.FunctionHandler;
import com.dtyunxi.huieryun.datalimit.utils.RuleResolver;
import com.dtyunxi.yundt.cube.meta.service.IMetaService;
import feign.RequestInterceptor;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnProperty(value={"dtyunxi.cube.starter.data.limit.enable"}, havingValue="true")
@Configuration
@ComponentScan(value={"com.dtyunxi.huieryun.datalimit"})
public class DataLimitAutoConfiguration
implements WebMvcConfigurer {
    private final Logger logger = LoggerFactory.getLogger(DataLimitAutoConfiguration.class);
    @Autowired
    private List<SqlSessionFactory> sqlSessionFactoryList;
    @Autowired(required=false)
    private IMetaDataQueryService metaDataQueryService;
    @Autowired(required=false)
    private IDataLimitRuleQueryService dataLimitRuleQueryService;
    @Autowired(required=false)
    private DataLimitRuleHandler dataLimitRuleHandler;
    @Lazy
    @Resource
    private IDataLimitRuleQueryApi userInfoApi;
    @Resource
    private ICacheService cacheService;

    @Bean
    public FunctionHandler functionHandler(@Value(value="${dtyunxi.cube.starter.data.limit.func.cache.enabled:false}") Boolean funcCalCacheEnable, @Value(value="${dtyunxi.cube.starter.data.limit.func.cache.timeout:10}") Integer funcCalCacheTime) {
        ICacheService cacheService = null;
        if (funcCalCacheEnable.booleanValue()) {
            this.logger.info("func cache is open, cache timeout:{}", (Object)funcCalCacheEnable);
            cacheService = this.cacheService;
        }
        return new FunctionHandler(cacheService, funcCalCacheTime);
    }

    @Bean
    @Lazy
    public IDataLimitRuleQueryService dataLimitRuleQueryService() {
        return new DataLimitRuleQueryServiceImpl(this.userInfoApi);
    }

    @Bean
    public DataLimitRuleHandler dataLimitRuleHandler(FunctionHandler functionHandler, @Value(value="${dtyunxi.cube.starter.data.limit.rule.cache.enable:false}") Boolean ruleCacheEnable, @Value(value="${dtyunxi.cube.starter.data.limit.rule.cache.timeout:5}") Integer ruleCacheTime) {
        ICacheService cacheService = null;
        if (ruleCacheEnable.booleanValue()) {
            this.logger.info("rule cache is open, cache timeout:{}", (Object)ruleCacheTime);
            cacheService = this.cacheService;
        }
        RuleResolver ruleResolver = new RuleResolver();
        return new DataLimitRuleHandler(this.dataLimitRuleQueryService, functionHandler, ruleResolver, cacheService, ruleCacheTime);
    }

    @PostConstruct
    public void addMySqlInterceptor() {
        DataLimitIntercept interceptor = new DataLimitIntercept();
        for (SqlSessionFactory sqlSessionFactory : this.sqlSessionFactoryList) {
            sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)interceptor);
        }
        this.logger.info("\u6570\u636e\u6743\u9650\u7ec4\u4ef6SQL\u62e6\u622a\u5668\u521d\u59cb\u5316\u5b8c\u6210");
    }

    @Bean
    public DataLimitAspect dataLimitAspect() {
        return new DataLimitAspect(this.dataLimitRuleHandler, this.metaDataQueryService);
    }

    @Bean
    public IMetaDataQueryService metaDataQueryService(MetaDataHolder metaDataHolder) {
        return new MetaDataQueryServiceImpl(metaDataHolder);
    }

    @Bean
    public MetaDataHolder metaDataHolder(IMetaService metaService) {
        return new MetaDataHolder(metaService);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new DataLimitInterceptor());
    }

    @Bean
    @ConditionalOnClass(value={RequestInterceptor.class})
    public FeignClientContextDataLimitFilter feignClientContextDataLimitFilter() {
        this.logger.info("\u521d\u59cb\u5316 \u8de8\u670d\u52a1\u5173\u95ed\u6570\u636e\u6743\u9650 \u62e6\u622a\u5668");
        return new FeignClientContextDataLimitFilter();
    }
}

