/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.data.limit.config;

import com.dtyunxi.cube.starter.data.limit.feign.IFieldLimitRuleQueryApi;
import com.dtyunxi.cube.starter.data.limit.intercept.FieldLimitRequestBodyAdvice;
import com.dtyunxi.cube.starter.data.limit.intercept.FieldLimitResponseBodyAdvice;
import com.dtyunxi.cube.starter.data.limit.service.IFieldMixService;
import com.dtyunxi.cube.starter.data.limit.service.impl.CommonFieldMixServiceImpl;
import com.dtyunxi.cube.starter.data.limit.service.impl.FieldTransferService;
import com.dtyunxi.cube.starter.data.limit.service.impl.IDFieldMixServiceImpl;
import com.dtyunxi.cube.starter.data.limit.service.impl.MailFieldMixServiceImpl;
import com.dtyunxi.cube.starter.data.limit.service.impl.NameFieldMixServiceImpl;
import com.dtyunxi.cube.starter.data.limit.service.impl.PhoneFieldMixServiceImpl;
import com.dtyunxi.cube.starter.data.limit.util.EncryptService;
import com.dtyunxi.cube.starter.data.limit.util.MixServiceHolder;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"dtyunxi.cube.starter.data.limit.field.enable"}, havingValue="true")
@ComponentScan(value={"com.dtyunxi.huieryun.datalimit"})
public class FieldLimitAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(FieldLimitAutoConfiguration.class);
    @Value(value="${dtyunxi.cube.starter.data.limit.field.secretkey:1234567890123456}")
    private String secretKey = "1234567890123456";

    @Bean
    public EncryptService initEncryptService() {
        return new EncryptService(this.secretKey);
    }

    @Bean
    public List<IFieldMixService> fieldMixServiceList() {
        logger.info("======> Field limit is enabled.");
        ArrayList<IFieldMixService> fieldMixServiceList = new ArrayList<IFieldMixService>();
        CommonFieldMixServiceImpl commonFieldMixService = new CommonFieldMixServiceImpl();
        IDFieldMixServiceImpl idFieldMixService = new IDFieldMixServiceImpl();
        MailFieldMixServiceImpl mailFieldMixService = new MailFieldMixServiceImpl();
        NameFieldMixServiceImpl nameFieldMixService = new NameFieldMixServiceImpl();
        PhoneFieldMixServiceImpl phoneFieldMixService = new PhoneFieldMixServiceImpl();
        fieldMixServiceList.add(commonFieldMixService);
        fieldMixServiceList.add(idFieldMixService);
        fieldMixServiceList.add(mailFieldMixService);
        fieldMixServiceList.add(nameFieldMixService);
        fieldMixServiceList.add(phoneFieldMixService);
        return fieldMixServiceList;
    }

    @Bean
    public MixServiceHolder mixServiceHolder(List<IFieldMixService> mixServiceList) {
        return new MixServiceHolder(mixServiceList);
    }

    @Bean
    public FieldTransferService fieldTransferService(MixServiceHolder mixServiceHolder) {
        return new FieldTransferService(mixServiceHolder);
    }

    @Bean
    @ConditionalOnMissingBean
    public FieldLimitResponseBodyAdvice fieldLimitResponseBodyAdvice(EncryptService encryptService, IFieldLimitRuleQueryApi fieldLimitRuleQueryApi, FieldTransferService fieldTransferService) {
        return new FieldLimitResponseBodyAdvice(encryptService, fieldLimitRuleQueryApi, fieldTransferService);
    }

    @Bean
    @ConditionalOnMissingBean
    public FieldLimitRequestBodyAdvice fieldLimitRequestBodyAdvice(EncryptService encryptService) {
        return new FieldLimitRequestBodyAdvice(encryptService);
    }
}

