/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.data.limit.feign;

import com.dtyunxi.cube.starter.data.limit.util.HystrixRequestVariableHolder;
import com.dtyunxi.huieryun.datalimit.aop.DataLimitAspect;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.util.CollectionUtils;

@ConditionalOnClass(value={RequestInterceptor.class})
public class FeignClientContextDataLimitFilter
implements RequestInterceptor {
    private static Logger logger = LoggerFactory.getLogger(FeignClientContextDataLimitFilter.class);

    public void apply(RequestTemplate template) {
        Set skipTables = DataLimitAspect.readSkipTable(HystrixRequestVariableHolder::getSkipTables);
        if (!CollectionUtils.isEmpty((Collection)skipTables)) {
            String value = StringUtils.join((Iterable)skipTables, (String)",");
            logger.debug("forward ignore tables \u4f20\u9012\u6570\u636e\u6743\u9650\u5ffd\u7565\u8868:{}", (Object)value);
            template.header("yes-data-limit-skip-tables", new String[]{value});
        } else {
            logger.debug("no ignore table to forward \u4e0d\u4f20\u9012\u6570\u636e\u6743\u9650\u5ffd\u7565\u8868");
        }
    }
}

