/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.data.limit.intercept;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.starter.data.limit.util.HystrixRequestVariableHolder;
import com.dtyunxi.huieryun.datalimit.aop.DataLimitAspect;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class DataLimitInterceptor
implements HandlerInterceptor {
    private static Logger logger = LoggerFactory.getLogger(DataLimitInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String skipTables;
        String sceneCode = ServiceContext.getContext().getAttachment("sceneCode");
        if (StringUtils.isEmpty((Object)sceneCode) && !StringUtils.isEmpty((Object)(sceneCode = request.getHeader("sceneCode")))) {
            ServiceContext.getContext().setAttachment("sceneCode", URLDecoder.decode(sceneCode, "UTF-8"));
        }
        if (StringUtils.isEmpty((Object)(skipTables = ServiceContext.getContext().getAttachment("yes-data-limit-skip-tables"))) && !StringUtils.isEmpty((Object)(skipTables = request.getHeader("yes-data-limit-skip-tables")))) {
            logger.debug("\u900f\u4f20\u4fe1\u606f\u8bbe\u5b9a\u4e86\u6570\u636e\u6743\u9650\u5ffd\u7565\u5185\u5bb9:{}", (Object)skipTables);
            ServiceContext.getContext().setAttachment("yes-data-limit-skip-tables", skipTables);
        }
        if (!StringUtils.isEmpty((Object)skipTables)) {
            logger.debug("\u4f7f\u7528\u900f\u4f20\u4fe1\u606f\u8bbe\u5b9a\u7684\u6570\u636e\u6743\u9650\u5ffd\u7565\u5185\u5bb9:{}", (Object)skipTables);
            DataLimitAspect.skipTables((String[])skipTables.split(","));
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable ModelAndView modelAndView) {
        DataLimitAspect.cleanSkipTable();
        HystrixRequestVariableHolder.destroy();
    }
}

