/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.data.limit.intercept;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.starter.data.limit.util.EncryptService;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdviceAdapter;

@ConditionalOnProperty(value={"dtyunxi.cube.starter.data.limit.field.enable"}, havingValue="true")
@RestControllerAdvice
public class FieldLimitRequestBodyAdvice
extends RequestBodyAdviceAdapter {
    private static final Logger logger = LoggerFactory.getLogger(FieldLimitRequestBodyAdvice.class);
    private final EncryptService encryptService;

    public FieldLimitRequestBodyAdvice(EncryptService encryptService) {
        this.encryptService = encryptService;
    }

    public boolean supports(MethodParameter methodParameter, @Nullable Type type, @Nullable Class<? extends HttpMessageConverter<?>> aClass) {
        return methodParameter.hasParameterAnnotation(RequestBody.class);
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, @Nullable MethodParameter parameter, @Nullable Type targetType, @Nullable Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        final HttpHeaders headers = inputMessage.getHeaders();
        String source = headers.getFirst("yes-req-source");
        logger.debug("=======>request-source:{}", (Object)source);
        if ("feign".equals(source)) {
            logger.debug("======> from feign call, do not handle");
            return inputMessage;
        }
        final InputStream inputStream = inputMessage.getBody();
        return new HttpInputMessage(){

            public InputStream getBody() throws IOException {
                return FieldLimitRequestBodyAdvice.this.deEncryptBody(inputStream);
            }

            public HttpHeaders getHeaders() {
                return headers;
            }
        };
    }

    private InputStream deEncryptBody(InputStream inputStream) throws IOException {
        long start = System.currentTimeMillis();
        String requestData = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        JSONObject object = null;
        try {
            object = JSONObject.parseObject((String)requestData);
        }
        catch (Exception e) {
            object = JSONObject.parseArray((String)requestData);
        }
        logger.debug("======>\u539f\u8bf7\u6c42\uff1a{}", (Object)object.toString());
        this.deEncryptField(object);
        logger.debug("======>\u89e3\u5bc6\u540e\u8bf7\u6c42:{}", (Object)object.toString());
        InputStream resultInputStream = IOUtils.toInputStream((String)object.toString(), (String)StandardCharsets.UTF_8.name());
        long duration = System.currentTimeMillis() - start;
        logger.debug("======>\u5b57\u6bb5\u6743\u9650\u5904\u7406\u8bf7\u6c42\u8017\u65f6\uff1a{} \u6beb\u79d2", (Object)duration);
        return resultInputStream;
    }

    private void deEncryptField(Object object) {
        if (object instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)object;
            jsonArray.forEach(this::deEncryptField);
        } else if (object instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)object;
            HashSet fieldNameSet = new HashSet(jsonObject.keySet());
            for (String fieldName : fieldNameSet) {
                Object fieldValue = jsonObject.get((Object)fieldName);
                if (null == fieldValue) continue;
                if (fieldValue instanceof JSONObject) {
                    this.deEncryptField(fieldValue);
                    continue;
                }
                if (fieldName.endsWith("##cipher##")) {
                    String originalFieldName = fieldName.substring(0, fieldName.length() - "##cipher##".length());
                    String originalFieldValue = this.encryptService.aesDecrypt(fieldValue);
                    originalFieldValue = "-".equals(originalFieldValue) ? null : originalFieldValue;
                    jsonObject.put(originalFieldName, (Object)originalFieldValue);
                    jsonObject.remove((Object)fieldName);
                    continue;
                }
                if (!fieldName.endsWith("##mix##")) continue;
                jsonObject.remove((Object)fieldName);
            }
        }
    }
}

