/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.data.limit.intercept;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.starter.data.limit.feign.IFieldLimitRuleQueryApi;
import com.dtyunxi.cube.starter.data.limit.feign.dto.BaseFieldReqDto;
import com.dtyunxi.cube.starter.data.limit.feign.dto.CommonFieldReqDto;
import com.dtyunxi.cube.starter.data.limit.feign.dto.CustomFieldReqDto;
import com.dtyunxi.cube.starter.data.limit.feign.dto.UserDataLimitRuleQueryRespDto;
import com.dtyunxi.cube.starter.data.limit.feign.dto.UserFieldLimitRuleQueryReqDto;
import com.dtyunxi.cube.starter.data.limit.feign.dto.UserFieldLimitRuleQueryRespDto;
import com.dtyunxi.cube.starter.data.limit.service.impl.FieldTransferService;
import com.dtyunxi.cube.starter.data.limit.util.EncryptService;
import com.dtyunxi.rest.RestResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ConditionalOnProperty(value={"dtyunxi.cube.starter.data.limit.field.enable"}, havingValue="true")
@RestControllerAdvice
public class FieldLimitResponseBodyAdvice
implements ResponseBodyAdvice {
    private static final Logger logger = LoggerFactory.getLogger(FieldLimitResponseBodyAdvice.class);
    private final EncryptService encryptService;
    private final IFieldLimitRuleQueryApi fieldLimitRuleQueryApi;
    private final FieldTransferService fieldTransferService;

    public FieldLimitResponseBodyAdvice(EncryptService encryptService, IFieldLimitRuleQueryApi fieldLimitRuleQueryApi, FieldTransferService fieldTransferService) {
        this.encryptService = encryptService;
        this.fieldLimitRuleQueryApi = fieldLimitRuleQueryApi;
        this.fieldTransferService = fieldTransferService;
    }

    public boolean supports(@Nullable MethodParameter methodParameter, @Nullable Class aClass) {
        return true;
    }

    public Object beforeBodyWrite(Object result, @Nullable MethodParameter methodParameter, @Nullable MediaType mediaType, @Nullable Class aClass, ServerHttpRequest serverHttpRequest, @Nullable ServerHttpResponse serverHttpResponse) {
        HttpHeaders headers = serverHttpRequest.getHeaders();
        String source = headers.getFirst("yes-req-source");
        logger.debug("=======>request-source:{}", (Object)source);
        if ("feign".equals(source)) {
            logger.debug("======> from feign call, do not handle");
            return result;
        }
        Long userId = ServiceContext.getContext().getRequestUserId();
        if (null == userId) {
            logger.warn("======>\u5f53\u524d\u7528\u6237id\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u5b57\u6bb5\u6743\u9650\u63a7\u5236");
            return result;
        }
        long start = System.currentTimeMillis();
        if (result instanceof RestResponse) {
            RestResponse response = (RestResponse)result;
            Object data = response.getData();
            if (this.requestWithoutHandle(data)) {
                return result;
            }
            List<BaseFieldReqDto> fieldReqDtoList = this.queryFieldRule(userId);
            if (CollectionUtils.isEmpty(fieldReqDtoList)) {
                logger.info("======> current user do not have filed rule");
                return result;
            }
            Map<String, BaseFieldReqDto> ruleDtoMap = fieldReqDtoList.stream().collect(Collectors.toMap(BaseFieldReqDto::getCode, rule -> rule, (k1, k2) -> k1));
            Object object = JSONObject.toJSON((Object)data);
            try {
                this.encryptField(object, ruleDtoMap);
            }
            catch (Exception e) {
                logger.error("\u5b57\u6bb5\u6743\u9650\u7ec4\u4ef6\u89e3\u6790\u54cd\u5e94\u7ed3\u679c\u5931\u8d25:" + e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            response.setData(object);
            logger.debug("======>\u5b57\u6bb5\u6743\u9650\u5904\u7406\u54cd\u5e94\u8017\u65f6\uff1a{} \u6beb\u79d2", (Object)(System.currentTimeMillis() - start));
            return response;
        }
        return result;
    }

    private boolean requestWithoutHandle(Object data) {
        if (data == null) {
            return true;
        }
        String responseClassSimpleName = data.getClass().getSimpleName();
        return responseClassSimpleName.equals(UserFieldLimitRuleQueryRespDto.class.getSimpleName()) || responseClassSimpleName.equals(UserDataLimitRuleQueryRespDto.class.getSimpleName());
    }

    private List<BaseFieldReqDto> queryFieldRule(Long userId) {
        UserFieldLimitRuleQueryReqDto userFieldLimitRuleQueryReqDto = new UserFieldLimitRuleQueryReqDto();
        userFieldLimitRuleQueryReqDto.setUserId(userId);
        RestResponse<UserFieldLimitRuleQueryRespDto> ruleResponse = this.fieldLimitRuleQueryApi.queryUserFieldLimitRule(userFieldLimitRuleQueryReqDto);
        if (null == ruleResponse || null == ruleResponse.getData()) {
            throw new IllegalStateException("\u83b7\u53d6\u7528\u6237\u89d2\u8272\u5bf9\u5e94\u7684\u5b57\u6bb5\u6743\u9650\u5931\u8d25");
        }
        UserFieldLimitRuleQueryRespDto respDto = (UserFieldLimitRuleQueryRespDto)((Object)ruleResponse.getData());
        Assert.notNull((Object)((Object)respDto));
        ArrayList<BaseFieldReqDto> allFieldList = new ArrayList<BaseFieldReqDto>();
        List<CommonFieldReqDto> commonFieldList = respDto.getCommonFields();
        List<CustomFieldReqDto> customFieldList = respDto.getCustomFields();
        if (!CollectionUtils.isEmpty(commonFieldList)) {
            allFieldList.addAll(commonFieldList);
        }
        if (!CollectionUtils.isEmpty(customFieldList)) {
            allFieldList.addAll(customFieldList);
        }
        return allFieldList;
    }

    private void encryptField(Object obj, Map<String, BaseFieldReqDto> ruleDtoMap) {
        if (obj instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)obj;
            jsonArray.stream().filter(json -> json instanceof JSONObject).forEach(subField -> this.encryptField(subField, ruleDtoMap));
        } else if (obj instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)obj;
            HashSet keySet = new HashSet(jsonObject.keySet());
            HashMap<String, String> additionalFieldMap = new HashMap<String, String>();
            for (String fieldName : keySet) {
                Object field = jsonObject.get((Object)fieldName);
                if (field instanceof JSONObject) {
                    this.encryptField(field, ruleDtoMap);
                    continue;
                }
                if (field instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)field;
                    jsonArray.stream().filter(json -> json instanceof JSONObject).forEach(subField -> this.encryptField(subField, ruleDtoMap));
                    continue;
                }
                if (!ruleDtoMap.containsKey(fieldName)) continue;
                Object fieldValue = jsonObject.get((Object)fieldName);
                String mixFieldName = fieldName + "##mix##";
                String encryptFieldName = fieldName + "##cipher##";
                additionalFieldMap.put(encryptFieldName, this.encryptService.aesEncrypt(fieldValue));
                additionalFieldMap.put(mixFieldName, this.fieldTransferService.generateMixValue(fieldValue, ruleDtoMap.get(fieldName)));
                additionalFieldMap.put(fieldName, null);
            }
            if (!CollectionUtils.isEmpty(additionalFieldMap)) {
                jsonObject.putAll(additionalFieldMap);
            }
        }
    }
}

