/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.data.limit.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.starter.data.limit.feign.IDataLimitRuleQueryApi;
import com.dtyunxi.cube.starter.data.limit.feign.dto.UserDataLimitRuleQueryReqDto;
import com.dtyunxi.cube.starter.data.limit.feign.dto.UserDataLimitRuleQueryRespDto;
import com.dtyunxi.huieryun.datalimit.dto.UserDataLimitRuleDto;
import com.dtyunxi.huieryun.datalimit.service.IDataLimitRuleQueryService;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DataLimitRuleQueryServiceImpl
implements IDataLimitRuleQueryService {
    private static final Logger logger = LoggerFactory.getLogger(DataLimitRuleQueryServiceImpl.class);
    private final IDataLimitRuleQueryApi userInfoApi;

    public DataLimitRuleQueryServiceImpl(IDataLimitRuleQueryApi userInfoApi) {
        this.userInfoApi = userInfoApi;
    }

    public UserDataLimitRuleDto getRuleList(Long userId, String entityCode) {
        UserDataLimitRuleDto userDataLimitRuleDto = new UserDataLimitRuleDto();
        if (null == userId) {
            logger.error("\u7528\u6237id\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u83b7\u53d6\u5230\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u6743\u9650\u89c4\u5219\uff01");
            return userDataLimitRuleDto;
        }
        UserDataLimitRuleQueryReqDto queryReqDto = new UserDataLimitRuleQueryReqDto();
        ArrayList entityCodeList = Lists.newArrayList();
        entityCodeList.add(entityCode);
        queryReqDto.setUserId(userId);
        queryReqDto.setEntityCodeList(entityCodeList);
        queryReqDto.setSceneCode(ServiceContext.getContext().getAttachment("sceneCode"));
        logger.info("getRuleList-userId:{},entityCode:{},sceneCode:{}", new Object[]{userId, entityCode, ServiceContext.getContext().getAttachment("sceneCode")});
        RestResponse<UserDataLimitRuleQueryRespDto> response = null;
        try {
            response = this.userInfoApi.queryUserDataLimitRule(queryReqDto);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (null == response || null == response.getData()) {
            return userDataLimitRuleDto;
        }
        UserDataLimitRuleQueryRespDto respDto = (UserDataLimitRuleQueryRespDto)((Object)response.getData());
        userDataLimitRuleDto.setHasOtherSceneRule(respDto.isHasOtherSceneRule());
        List<UserDataLimitRuleQueryRespDto.RuleRespDto> responseDtoList = respDto.getRuleList();
        if (CollectionUtil.isNotEmpty(responseDtoList)) {
            userDataLimitRuleDto.setRuleList(responseDtoList.stream().map(UserDataLimitRuleQueryRespDto.RuleRespDto::getExpression).filter(s -> !StringUtils.isEmpty((Object)s)).collect(Collectors.toList()));
        }
        return userDataLimitRuleDto;
    }
}

