/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.data.limit.service.impl;

import com.dtyunxi.cube.starter.data.limit.constant.DataLimitConstant;
import com.dtyunxi.cube.starter.data.limit.service.IFieldMixService;
import com.dtyunxi.cube.starter.data.limit.util.StarUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class IDFieldMixServiceImpl
implements IFieldMixService {
    private static final Logger logger = LoggerFactory.getLogger(IDFieldMixServiceImpl.class);

    @Override
    public Integer getMixType() {
        return DataLimitConstant.DESEN_RULE_ID_CARD;
    }

    @Override
    public String generateMixValue(Object value) {
        if (StringUtils.isEmpty((Object)value)) {
            return "-";
        }
        boolean isString = value instanceof String;
        if (!isString) {
            logger.warn("======>\u8eab\u4efd\u8bc1\u5b57\u6bb5\u503c\u4e0d\u662f\u5b57\u7b26\u4e32\u7c7b\u578b\uff0c\u91c7\u7528\u9ed8\u8ba4\u6df7\u6dc6\u503c");
            return "-";
        }
        String idNum = (String)value;
        int idNumLength = idNum.length();
        if (idNumLength <= 10) {
            logger.warn("======>\u8eab\u4efd\u8bc1\u5b57\u6bb5\u683c\u5f0f\u4e0d\u6b63\u786e\uff08\u957f\u5ea6\u5c0f\u4e8e10\uff09\uff0c\u5168\u90e8\u5b57\u7b26\u91c7\u7528\u661f\u53f7\u66ff\u6362");
            return StarUtil.getStartMark(idNumLength);
        }
        idNum = idNum.substring(0, 6) + StarUtil.getStartMark(idNumLength - 10) + idNum.substring(idNum.length() - 4);
        return idNum;
    }

    public static void main(String[] args) {
        IDFieldMixServiceImpl nameFieldMixService = new IDFieldMixServiceImpl();
        System.out.println("idCarNum:" + nameFieldMixService.generateMixValue("65896547589654x"));
        System.out.println("idCarNum:" + nameFieldMixService.generateMixValue("6542"));
        System.out.println("idCarNum:" + nameFieldMixService.generateMixValue(123));
        System.out.println("idCarNum:" + nameFieldMixService.generateMixValue(null));
        System.out.println("idCarNum:" + nameFieldMixService.generateMixValue(""));
    }
}

