/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.data.limit.service.impl;

import com.dtyunxi.cube.starter.data.limit.constant.DataLimitConstant;
import com.dtyunxi.cube.starter.data.limit.service.IFieldMixService;
import com.dtyunxi.cube.starter.data.limit.util.StarUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class MailFieldMixServiceImpl
implements IFieldMixService {
    private static final Logger logger = LoggerFactory.getLogger(MailFieldMixServiceImpl.class);

    @Override
    public Integer getMixType() {
        return DataLimitConstant.DESEN_RULE_MAIL;
    }

    @Override
    public String generateMixValue(Object value) {
        if (StringUtils.isEmpty((Object)value)) {
            return "-";
        }
        boolean isString = value instanceof String;
        if (!isString) {
            logger.warn("======>\u90ae\u7bb1\u5b57\u6bb5\u503c\u4e0d\u662f\u5b57\u7b26\u4e32\u7c7b\u578b\uff0c\u91c7\u7528\u7a7a\u503c\u5bf9\u5e94\u7684\u6df7\u6dc6\u503c");
            return "-";
        }
        String fullMailAccount = (String)value;
        if (!fullMailAccount.contains("@")) {
            logger.warn("======>\u90ae\u7bb1\u683c\u5f0f\u9519\u8bef\uff08\u4e0d\u5305\u542b@\uff09");
            return "-";
        }
        String mailAccount = fullMailAccount.substring(0, fullMailAccount.lastIndexOf("@"));
        int mailAccountLength = mailAccount.length();
        mailAccount = mailAccountLength <= 4 ? StarUtil.getStartMark(mailAccountLength) : mailAccount.substring(0, 2) + StarUtil.getStartMark(mailAccountLength - 4) + mailAccount.substring(mailAccountLength - 2);
        mailAccount = mailAccount + fullMailAccount.substring(fullMailAccount.lastIndexOf("@"));
        return mailAccount;
    }

    public static void main(String[] args) {
        MailFieldMixServiceImpl nameFieldMixService = new MailFieldMixServiceImpl();
        System.out.println("mail:" + nameFieldMixService.generateMixValue("admi@qq.com"));
        System.out.println("mail:" + nameFieldMixService.generateMixValue("456545698@qq.com"));
        System.out.println("mail:" + nameFieldMixService.generateMixValue("456545698"));
        System.out.println("mail:" + nameFieldMixService.generateMixValue("@qq.com"));
        System.out.println("mail:" + nameFieldMixService.generateMixValue("admi@"));
        System.out.println("mail:" + nameFieldMixService.generateMixValue(null));
        System.out.println("mail:" + nameFieldMixService.generateMixValue(""));
    }
}

