/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.data.limit.service.impl;

import com.dtyunxi.cube.starter.data.limit.constant.DataLimitConstant;
import com.dtyunxi.cube.starter.data.limit.service.IFieldMixService;
import com.dtyunxi.cube.starter.data.limit.util.StarUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class NameFieldMixServiceImpl
implements IFieldMixService {
    private static final Logger logger = LoggerFactory.getLogger(NameFieldMixServiceImpl.class);

    @Override
    public Integer getMixType() {
        return DataLimitConstant.DESEN_RULE_NAME;
    }

    @Override
    public String generateMixValue(Object value) {
        if (StringUtils.isEmpty((Object)value)) {
            return "-";
        }
        boolean isString = value instanceof String;
        if (!isString) {
            logger.warn("======>\u59d3\u540d\u5b57\u6bb5\u503c\u4e0d\u662f\u5b57\u7b26\u4e32\u7c7b\u578b\uff0c\u91c7\u7528\u7a7a\u503c\u5bf9\u5e94\u7684\u6df7\u6dc6\u503c");
            return "-";
        }
        String name = (String)value;
        int nameLength = name.length();
        name = nameLength > 2 ? name.substring(0, 1) + StarUtil.getStartMark(nameLength - 2) + name.substring(name.length() - 1) : (nameLength == 2 ? name.substring(0, 1) + "*" : "*");
        return name;
    }

    public static void main(String[] args) {
        NameFieldMixServiceImpl nameFieldMixService = new NameFieldMixServiceImpl();
        System.out.println("name:" + nameFieldMixService.generateMixValue("\u5f20"));
        System.out.println("name:" + nameFieldMixService.generateMixValue("\u5f20\u4e09"));
        System.out.println("name:" + nameFieldMixService.generateMixValue("\u738b\u56db\u4e94"));
        System.out.println("name:" + nameFieldMixService.generateMixValue("\u674e\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03"));
        System.out.println("name:" + nameFieldMixService.generateMixValue(3665));
        System.out.println("name:" + nameFieldMixService.generateMixValue(null));
        System.out.println("name:" + nameFieldMixService.generateMixValue(""));
    }
}

