/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.data.limit.service.impl;

import com.dtyunxi.cube.starter.data.limit.constant.DataLimitConstant;
import com.dtyunxi.cube.starter.data.limit.service.IFieldMixService;
import com.dtyunxi.cube.starter.data.limit.util.StarUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class PhoneFieldMixServiceImpl
implements IFieldMixService {
    private static final Logger logger = LoggerFactory.getLogger(PhoneFieldMixServiceImpl.class);

    @Override
    public Integer getMixType() {
        return DataLimitConstant.DESEN_RULE_PHONE;
    }

    @Override
    public String generateMixValue(Object value) {
        if (StringUtils.isEmpty((Object)value)) {
            return "-";
        }
        boolean isString = value instanceof String;
        if (!isString) {
            logger.warn("======>\u7535\u8bdd\u5b57\u6bb5\u503c\u4e0d\u662f\u5b57\u7b26\u4e32\u7c7b\u578b\uff0c\u91c7\u7528\u7a7a\u503c\u5bf9\u5e94\u7684\u6df7\u6dc6\u503c");
            return "-";
        }
        String phone = (String)value;
        int phoneLength = phone.length();
        if (phoneLength <= 7) {
            logger.warn("======>\u7535\u8bdd\u5b57\u6bb5\u503c\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
            return StarUtil.getStartMark(phoneLength);
        }
        phone = phone.substring(0, 3) + StarUtil.getStartMark(phoneLength - 7) + phone.substring(phoneLength - 4);
        return phone;
    }

    public static void main(String[] args) {
        PhoneFieldMixServiceImpl nameFieldMixService = new PhoneFieldMixServiceImpl();
        System.out.println("phone:" + nameFieldMixService.generateMixValue("15915896596"));
        System.out.println("phone:" + nameFieldMixService.generateMixValue("12313"));
        System.out.println("phone:" + nameFieldMixService.generateMixValue(null));
        System.out.println("phone:" + nameFieldMixService.generateMixValue(""));
    }
}

