/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.data.limit.util;

import com.dtyunxi.cube.starter.data.limit.util.DateUtil;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptService {
    private static final Logger logger = LoggerFactory.getLogger(EncryptService.class);
    private static final String AES = "AES";
    private static final int AES_LENGTH_128 = 128;
    private Cipher encryptCipher;
    private Cipher decryptCipher;

    public EncryptService(String secretKey) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(AES);
            keyGenerator.init(128);
            this.encryptCipher = Cipher.getInstance(AES);
            this.encryptCipher.init(1, new SecretKeySpec(secretKey.getBytes(), AES));
            this.decryptCipher = Cipher.getInstance(AES);
            this.decryptCipher.init(2, new SecretKeySpec(secretKey.getBytes(), AES));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private String base64Encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    private byte[] base64Decode(String base64Code) throws Exception {
        return Base64.getDecoder().decode(base64Code);
    }

    public String aesEncrypt(Object content) {
        if (content == null || StringUtils.isBlank((CharSequence)content.toString())) {
            content = "-";
        }
        String aesEncryptContent = content.toString();
        String formatDate = DateUtil.cstDateFormat(content.toString());
        if (StringUtils.isNotBlank((CharSequence)formatDate)) {
            aesEncryptContent = formatDate;
        }
        try {
            return this.base64Encode(this.encryptCipher.doFinal(aesEncryptContent.getBytes(StandardCharsets.UTF_8)));
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String aesDecrypt(Object encryptStr) {
        if (encryptStr == null || StringUtils.isBlank((CharSequence)encryptStr.toString())) {
            return null;
        }
        try {
            return new String(this.decryptCipher.doFinal(this.base64Decode(encryptStr.toString())));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        EncryptService encryptService = new EncryptService("1234567890123456");
        String content = "tom";
        System.out.println("\u52a0\u5bc6\u524d\uff1a" + content);
        String encrypt = encryptService.aesEncrypt(content);
        System.out.println("\u52a0\u5bc6\u540e\uff1a" + encrypt + ",\u957f\u5ea6:" + encrypt.length());
        String decrypt = encryptService.aesDecrypt(encrypt);
        System.out.println("\u89e3\u5bc6\u540e\uff1a" + decrypt);
    }
}

