/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.data.limit.util;

import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableDefault;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixRequestVariableHolder {
    private static final HystrixRequestVariableDefault<Set<String>> skipTables = new HystrixRequestVariableDefault();
    private static final Logger logger = LoggerFactory.getLogger(HystrixRequestVariableHolder.class);

    public static Set<String> getSkipTables() {
        logger.debug(" get skipTables in hystrix");
        HystrixRequestVariableHolder.initServiceContext();
        return (Set)skipTables.get();
    }

    public static void setSkipTables(Set<String> tables) {
        logger.debug(" set skipTables in hystrix");
        HystrixRequestVariableHolder.initServiceContext();
        skipTables.set(tables);
    }

    private static void initServiceContext() {
        if (!HystrixRequestContext.isCurrentThreadInitialized()) {
            HystrixRequestContext.initializeContext();
        }
    }

    public static void destroy() {
        logger.debug("HystrixRequestVariableHolder destroy");
        if (HystrixRequestContext.isCurrentThreadInitialized()) {
            HystrixRequestContext.getContextForCurrentThread().shutdown();
            logger.debug(" HystrixRequestContext destroyed");
        }
    }
}

