/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.meta.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.starter.meta.common.MetaConstants;
import com.dtyunxi.cube.starter.meta.dto.BundleApiRespDto;
import com.dtyunxi.cube.starter.meta.service.IDataLimitFunctionService;
import com.dtyunxi.cube.starter.meta.utils.FileUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.yundt.cube.center.meta.dao.das.FuncDas;
import com.dtyunxi.yundt.cube.center.meta.dao.eo.FuncEo;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class DataLimitFunctionServiceImpl
implements IDataLimitFunctionService {
    private static final Logger logger = LoggerFactory.getLogger(DataLimitFunctionServiceImpl.class);
    @Resource
    private FuncDas funcDas;
    @Value(value="${app.started.lock.wait.timeout:1000}")
    private int waitTimeout;
    @Value(value="${app.started.lock.lease.time:1000}")
    private int leaseTime;
    private static final String NAME = "DATALIMIT_FUNC";
    @Resource
    private ILockService lockService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void loadFunction() {
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock("META_" + this.getClass().getSimpleName(), NAME, this.waitTimeout, this.leaseTime, TimeUnit.SECONDS);
            if (mutex == null) {
                logger.warn("\u6570\u636e\u6743\u9650\u51fd\u6570\u626b\u63cf\u5165\u5e93 \u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
                this.lockService.unlock(mutex);
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u6570\u636e\u6743\u9650\u51fd\u6570\u626b\u63cf\u5165\u5e93 \u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6210\u529f");
            }
            List<FuncEo> funcEoList = this.loadFromFile("META-INF/bundle-api.json");
            this.addOrUpdateFunc(funcEoList);
            this.lockService.unlock(mutex);
            return;
        }
        catch (IOException e) {
            logger.error("\u52a0\u8f7d\u89e3\u6790\u51fd\u6570\u51fa\u9519:" + e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            this.lockService.unlock(mutex);
        }
    }

    private void addOrUpdateFunc(List<FuncEo> funcEoList) {
        if (!CollectionUtils.isEmpty(funcEoList)) {
            this.funcDas.deleteByExample((BaseEo)new FuncEo());
            HashSet<FuncEo> funcEoSet = new HashSet<FuncEo>(32);
            for (FuncEo funcEo : funcEoList) {
                funcEoSet.add(funcEo);
            }
            for (FuncEo funcEo : funcEoSet) {
                this.funcDas.insert((BaseEo)funcEo);
            }
        }
    }

    private List<FuncEo> loadFromFile(String fileName) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> jsonFiles = classLoader.getResources(fileName);
        logger.info("\u5f53\u524d\u89e3\u6790\u7684\u6587\u4ef6\u540d:{}", (Object)fileName);
        ArrayList funcEoList = Lists.newArrayList();
        while (jsonFiles.hasMoreElements()) {
            String json = FileUtil.load2Json(jsonFiles.nextElement());
            try {
                JSONArray jsonArray;
                List<BundleApiRespDto> bundleApiRespDtoList;
                String version;
                String artifactId;
                JSONObject jsonObject = JSONObject.parseObject((String)json);
                String groupId = (String)jsonObject.get((Object)"groupId");
                List<FuncEo> funcEos = this.getFromApi(groupId, artifactId = (String)jsonObject.get((Object)"artifactId"), version = (String)jsonObject.get((Object)"version"), bundleApiRespDtoList = (jsonArray = jsonObject.getJSONArray("apiList")).stream().filter(object -> object instanceof JSONObject).map(object -> {
                    JSONObject tmpJsonObject = (JSONObject)object;
                    return (BundleApiRespDto)tmpJsonObject.toJavaObject(BundleApiRespDto.class);
                }).collect(Collectors.toList()));
                if (CollectionUtils.isEmpty(funcEos)) continue;
                funcEoList.addAll(funcEos);
            }
            catch (Throwable throwable) {
                logger.info("{}\u6587\u4ef6\u5185\u5bb9\u89e3\u6790\u6210json\u5f02\u5e38\uff1a", (Object)fileName, (Object)throwable);
            }
        }
        return funcEoList;
    }

    private List<FuncEo> getFromApi(String groupId, String artifactId, String version, List<BundleApiRespDto> bundleApiList) {
        ArrayList funcEoList = Lists.newArrayList();
        if (null == bundleApiList || CollectionUtils.isEmpty(bundleApiList)) {
            return funcEoList;
        }
        for (BundleApiRespDto bundleApi : bundleApiList) {
            List<BundleApiRespDto.Path> pathList = bundleApi.getPaths();
            for (BundleApiRespDto.Path api : pathList) {
                if (!MetaConstants.DATA_LIMIT_FUNCTION.equals(api.getDataLimitFunc())) continue;
                logger.debug("\u52a0\u8f7d\u5230\u6570\u636e\u6743\u9650\u51fd\u6570:" + api.getPath());
                funcEoList.add(this.getFuncDto(groupId, artifactId, version, api));
            }
        }
        return funcEoList;
    }

    private FuncEo getFuncDto(String groupId, String artifactId, String version, BundleApiRespDto.Path api) {
        FuncEo funcEo = new FuncEo();
        BeanUtils.copyProperties((Object)api, (Object)funcEo);
        funcEo.setFuncName(api.getFuncName());
        funcEo.setBeanName(api.getBeanName());
        funcEo.setFuncDesc(api.getFuncDesc());
        funcEo.setRequestParam(JSON.toJSONString(api.getRequestParams()));
        funcEo.setResponseParam(JSON.toJSONString((Object)api.getResponseParam()));
        funcEo.setGroupId(groupId);
        funcEo.setArtifactId(artifactId);
        funcEo.setVersion(version);
        return funcEo;
    }
}

