/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.plugin.mq;

import com.dtyunxi.cube.plugin.mq.AliyunMessageProperties;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.plugin.mq.IMQConsumerRegister;
import com.dtyunxi.cube.plugin.mq.KafkaMessageProperties;
import com.dtyunxi.cube.plugin.mq.MessageProperties;
import com.dtyunxi.cube.plugin.mq.RabbitMessageProperties;
import com.dtyunxi.cube.plugin.mq.RocketMessageProperties;
import com.dtyunxi.cube.plugin.mq.TopicRegistryVo;
import com.dtyunxi.cube.plugin.mq.impl.CommonsMqHelper;
import com.dtyunxi.cube.plugin.mq.impl.CommonsMqServiceImpl;
import com.dtyunxi.cube.plugin.mq.impl.DefaultMQConsumerRegister;
import com.dtyunxi.cube.plugin.mq.runner.MQRegisterRunner;
import com.dtyunxi.huieryun.mq.api.IConsumer;
import com.dtyunxi.huieryun.mq.api.IMQService;
import com.dtyunxi.huieryun.mq.api.IProducer;
import com.dtyunxi.huieryun.mq.api.MQFactory;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties(value={MessageProperties.class, TopicRegistryVo.class, RocketMessageProperties.class, RabbitMessageProperties.class, AliyunMessageProperties.class, KafkaMessageProperties.class})
public class CubeMQAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CubeMQAutoConfiguration.class);
    private final MessageRegistryVo messageRegistryVo;
    @Value(value="${cube.starter.mq.default.consumer:}")
    private String defaultConsumer;
    @Value(value="${spring.application.name:}")
    private String envModule;
    private final TopicRegistryVo topicRegistryVo;
    @Value(value="${cube.global.profile:dev}")
    private String globalProfile;

    public CubeMQAutoConfiguration(MessageProperties messageRegistryVo, TopicRegistryVo topicRegistryVo) {
        this.messageRegistryVo = messageRegistryVo;
        this.topicRegistryVo = topicRegistryVo;
    }

    @Bean
    @ConditionalOnMissingBean
    public IProducer producerBean(@Qualifier(value="createIMQService") IMQService createIMQService) {
        return createIMQService.createProducer();
    }

    @Bean
    @ConditionalOnMissingBean
    public IConsumer consumerBean(@Qualifier(value="createIMQService") IMQService createIMQService) {
        return createIMQService.createConsumer();
    }

    @Bean
    @ConditionalOnMissingBean
    public IMQService createIMQService() {
        logger.info("messageRegistryVo \uff1a {}", (Object)this.messageRegistryVo);
        return MQFactory.createMQ((MessageRegistryVo)this.messageRegistryVo);
    }

    @Primary
    @Bean
    @ConditionalOnMissingBean
    public ICommonsMqService commonsMqService(@Qualifier(value="producerBean") IProducer commonsProducer, @Qualifier(value="consumerBean") IConsumer commonsConsumer) {
        return new CommonsMqServiceImpl(commonsProducer, commonsConsumer, this.messageRegistryVo, this.globalProfile, this.topicRegistryVo);
    }

    @Bean
    public IMQConsumerRegister defaultMQConsumerRegister() {
        return new DefaultMQConsumerRegister(this.messageRegistryVo, this.topicRegistryVo, this.getConsumer());
    }

    @Bean
    @DependsOn(value={"springBeanUtil"})
    @ConditionalOnProperty(prefix="cube.starter.mq", value={"enabled"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean
    public MQRegisterRunner mqRegisterRunner(@Qualifier(value="commonsMqService") ICommonsMqService commonsMqService, List<IMQConsumerRegister> consumerRegisterList) {
        return new MQRegisterRunner(commonsMqService, consumerRegisterList);
    }

    private String getConsumer() {
        return CommonsMqHelper.parseConsumer(this.messageRegistryVo, this.defaultConsumer, this.envModule);
    }

    @Bean(name={"rocketCommonsMqService"})
    @ConditionalOnProperty(prefix="huieryun.mq.rocket.registryvo", name={"type"}, havingValue="ALIYUN")
    public ICommonsMqService rocketCommonsMqService(RocketMessageProperties messageProperties) {
        IMQService imqService = MQFactory.createMQ((MessageRegistryVo)messageProperties);
        return new CommonsMqServiceImpl(imqService.createProducer(), imqService.createConsumer(), messageProperties, this.globalProfile, this.topicRegistryVo);
    }

    @Bean(name={"rabbitCommonsMqService"})
    @ConditionalOnBean(name={"rabbitMqService"})
    public ICommonsMqService rabbitCommonsMqService(RabbitMessageProperties messageProperties) {
        IMQService imqService = MQFactory.createMQ((MessageRegistryVo)messageProperties);
        return new CommonsMqServiceImpl(imqService.createProducer(), imqService.createConsumer(), messageProperties, this.globalProfile, this.topicRegistryVo);
    }

    @Bean(name={"aliyunCommonsMqService"})
    @ConditionalOnProperty(prefix="huieryun.mq.aliyun.registryvo", name={"type"}, havingValue="ALIYUN")
    public ICommonsMqService aliyunCommonsMqService(AliyunMessageProperties messageProperties) {
        IMQService imqService = MQFactory.createMQ((MessageRegistryVo)messageProperties);
        return new CommonsMqServiceImpl(imqService.createProducer(), imqService.createConsumer(), messageProperties, this.globalProfile, this.topicRegistryVo);
    }

    @Bean(name={"kafkaCommonsMqService"})
    @ConditionalOnProperty(prefix="huieryun.mq.kafka.registryvo", name={"type"}, havingValue="KAFKA")
    public ICommonsMqService kafkaCommonsMqService(KafkaMessageProperties messageProperties) {
        IMQService imqService = MQFactory.createMQ((MessageRegistryVo)messageProperties);
        return new CommonsMqServiceImpl(imqService.createProducer(), imqService.createConsumer(), (MessageRegistryVo)messageProperties, this.globalProfile, this.topicRegistryVo);
    }
}

