/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.plugin.mq.impl;

import com.dtyunxi.cube.plugin.mq.MessageProperties;
import com.dtyunxi.cube.plugin.mq.TopicRegistryVo;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.constant.MessageType;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.util.SpringBeanUtil;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

public class CommonsMqHelper {
    public static final Map<String, Map<String, Map<String, Map<String, IMessageProcessor>>>> processMap = new HashMap<String, Map<String, Map<String, Map<String, IMessageProcessor>>>>();

    private static MessageRegistryVo getMessageRegistryVo() {
        return (MessageRegistryVo)SpringBeanUtil.getApplicationContext().getBean(MessageProperties.class);
    }

    private static TopicRegistryVo getTopicRegistryVo() {
        return (TopicRegistryVo)SpringBeanUtil.getApplicationContext().getBean(TopicRegistryVo.class);
    }

    private static String getEnvModule() {
        return SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("spring.application.name");
    }

    private static String getDefaultConsumer() {
        return SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("cube.starter.mq.default.consumer");
    }

    private static String getConsumerPrefix() {
        return SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("cube.starter.mq.alimq.auto-add-prefix");
    }

    public static void addProcessor(String topic, String consumer, String tag, String msgType, IMessageProcessor bean) {
        Map<String, Map<String, IMessageProcessor>> tMap;
        Map<Object, Object> map;
        topic = CommonsMqHelper.parseStrtoUppercase(topic);
        if (processMap.get(consumer = CommonsMqHelper.parseStrtoUppercase(consumer)) == null) {
            map = new HashMap();
            processMap.put(consumer, map);
        }
        if ((map = processMap.get(consumer)).get(topic) == null) {
            HashMap tmp = new HashMap();
            processMap.get(consumer).put(topic, tmp);
        }
        if ((tMap = processMap.get(consumer).get(topic)).get(msgType) == null) {
            HashMap tmp = new HashMap();
            processMap.get(consumer).get(topic).put(msgType, tmp);
        }
        processMap.get(consumer).get(topic).get(msgType).put(tag, bean);
    }

    public static void addSingleProcessor(String topic, String consumer, String tag, IMessageProcessor processor) {
        consumer = CommonsMqHelper.parseConsumer(CommonsMqHelper.getMessageRegistryVo(), consumer, CommonsMqHelper.getEnvModule());
        CommonsMqHelper.addProcessor(topic, consumer, tag, "single", processor);
    }

    public static void addSingleProcessor(String topic, String tag, IMessageProcessor processor) {
        CommonsMqHelper.addSingleProcessor(topic, CommonsMqHelper.getDefaultConsumer(), tag, processor);
    }

    public static void addSingleProcessor(String tag, IMessageProcessor processor) {
        CommonsMqHelper.addSingleProcessor(CommonsMqHelper.getTopicRegistryVo().getSingleTopic(), CommonsMqHelper.getDefaultConsumer(), tag, processor);
    }

    public static void addPublishProcessor(String topic, String consumer, String tag, IMessageProcessor processor) {
        consumer = CommonsMqHelper.parseConsumer(CommonsMqHelper.getMessageRegistryVo(), consumer, CommonsMqHelper.getEnvModule());
        CommonsMqHelper.addProcessor(topic, consumer, tag, "publish", processor);
    }

    public static void addPublishProcessor(String topic, String tag, IMessageProcessor processor) {
        CommonsMqHelper.addPublishProcessor(topic, CommonsMqHelper.getDefaultConsumer(), tag, processor);
    }

    public static void addPublishProcessor(String tag, IMessageProcessor processor) {
        CommonsMqHelper.addPublishProcessor(CommonsMqHelper.getTopicRegistryVo().getPublishTopic(), CommonsMqHelper.getDefaultConsumer(), tag, processor);
    }

    public static Map<String, Map<String, IMessageProcessor>> getSingleProcessors(String consumer) {
        Map<String, Map<String, Map<String, IMessageProcessor>>> tmpMap = processMap.get(consumer);
        HashMap<String, Map<String, IMessageProcessor>> target = null;
        for (String topic : tmpMap.keySet()) {
            if (null == target) {
                target = new HashMap<String, Map<String, IMessageProcessor>>();
            }
            if (!tmpMap.get(topic).containsKey("single")) continue;
            target.put(topic, tmpMap.get(topic).get("single"));
        }
        return target;
    }

    public static Map<String, Map<String, IMessageProcessor>> getPublishProcessors(String consumer) {
        Map<String, Map<String, Map<String, IMessageProcessor>>> tmpMap = processMap.get(consumer);
        HashMap<String, Map<String, IMessageProcessor>> target = null;
        for (String topic : tmpMap.keySet()) {
            if (null == target) {
                target = new HashMap<String, Map<String, IMessageProcessor>>();
            }
            if (!tmpMap.get(topic).containsKey("publish")) continue;
            target.put(topic, tmpMap.get(topic).get("publish"));
        }
        return target;
    }

    public static Map<String, Map<String, IMessageProcessor>> getAllProcessors(String consumer) {
        Map<String, Map<String, Map<String, IMessageProcessor>>> tmpMap = processMap.get(consumer);
        HashMap target = null;
        for (String topic : tmpMap.keySet()) {
            if (null == target) {
                target = new HashMap();
            }
            HashMap<String, IMessageProcessor> tmp = new HashMap<String, IMessageProcessor>();
            if (tmpMap.get(topic).containsKey("publish")) {
                tmp.putAll(tmpMap.get(topic).get("publish"));
            }
            if (tmpMap.get(topic).containsKey("single")) {
                tmp.putAll(tmpMap.get(topic).get("single"));
            }
            target.put(topic, tmp);
        }
        return target;
    }

    private static String parseStrtoUppercase(String str) {
        if (StringUtils.isEmpty((Object)str)) {
            return null;
        }
        return str.replace("-", "_").toUpperCase();
    }

    public static String parseConsumer(MessageRegistryVo messageRegistryVo, String consumer, String defaultValue) {
        String csf;
        if (MessageType.ALIYUN.getName().equalsIgnoreCase(messageRegistryVo.getType())) {
            csf = StringUtils.isEmpty((Object)consumer) ? defaultValue : consumer;
            if (!(StringUtils.isEmpty((Object)(csf = CommonsMqHelper.parseStrtoUppercase(csf))) || csf.startsWith("CID_") || csf.startsWith("GID_"))) {
                String prefix = CommonsMqHelper.getConsumerPrefix();
                csf = StringUtils.isEmpty((Object)prefix) ? "GID_" + csf : prefix + "_" + csf;
            }
        } else {
            csf = StringUtils.isEmpty((Object)consumer) ? defaultValue : consumer;
        }
        return csf;
    }
}

