/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.maven.plugin.complement.swagger;

import com.dtyunxi.cube.enhance.generator.annotation.CubeDto;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.visitor.ModifierVisitor;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CubeSwaggerASTVisitor<A>
extends ModifierVisitor<A> {
    private boolean doAppend = false;
    private Map<String, String> apiModelValueMembers;
    private Map<String, String> fieldComments;

    public Node visit(ClassOrInterfaceDeclaration n, A arg) {
        boolean hasCubeDtoAnnotation = false;
        boolean hasApiModelAnnotation = false;
        for (AnnotationExpr ann : n.getAnnotations()) {
            if (CubeDto.class.getSimpleName().equals(ann.getName().getIdentifier())) {
                hasCubeDtoAnnotation = true;
            }
            if (!ApiModel.class.getSimpleName().equals(ann.getName().getIdentifier())) continue;
            hasApiModelAnnotation = true;
        }
        if (hasCubeDtoAnnotation && !hasApiModelAnnotation) {
            this.doAppend = true;
            this.apiModelValueMembers = this.parsedApiModel(n);
            this.fieldComments = this.parseField(n);
        }
        return n;
    }

    private Map<String, String> parseField(ClassOrInterfaceDeclaration n) {
        HashMap<String, String> fieldComments = new HashMap<String, String>();
        for (BodyDeclaration member : n.getMembers()) {
            Pair<String, String> item;
            if (!(member instanceof FieldDeclaration) || (item = this.parseApiModelProperty4field((FieldDeclaration)member)) == null) continue;
            fieldComments.put((String)item.getLeft(), (String)item.getRight());
        }
        return fieldComments;
    }

    private Pair<String, String> parseApiModelProperty4field(FieldDeclaration fieldDeclaration) {
        Class<ApiModelProperty> annotationClazz = ApiModelProperty.class;
        for (AnnotationExpr annotation : fieldDeclaration.getAnnotations()) {
            if (!annotationClazz.getCanonicalName().equals(annotation.getNameAsString())) continue;
            return null;
        }
        Optional comment = fieldDeclaration.getComment();
        if (!comment.isPresent()) {
            throw new RuntimeException("\u7f3a\u5c11\u5c5e\u6027\u7684\u6ce8\u91ca:" + fieldDeclaration.getVariable(0).getNameAsString());
        }
        String commentContent = ((Comment)comment.get()).asJavadocComment().parse().getDescription().toText();
        String fieldName = ((VariableDeclarator)fieldDeclaration.getChildNodes().get(0)).getName().getIdentifier();
        return Pair.of((Object)fieldName, (Object)commentContent);
    }

    private Map<String, String> parsedApiModel(ClassOrInterfaceDeclaration n) {
        Optional comment = n.getComment();
        if (!comment.isPresent()) {
            throw new RuntimeException("\u7f3a\u5c11\u7c7b\u6ce8\u91ca:" + n.getNameAsString());
        }
        String commentContent = ((Comment)comment.get()).asJavadocComment().parse().getDescription().toText();
        String[] split = StringUtils.split((String)commentContent, (String)"\n", (int)2);
        LinkedHashMap<String, String> apiModelValueMembers = new LinkedHashMap<String, String>();
        apiModelValueMembers.put("value", split[0]);
        if (split.length > 1) {
            apiModelValueMembers.put("description", split[1]);
        }
        return apiModelValueMembers;
    }

    public boolean isDoAppend() {
        return this.doAppend;
    }

    public Map<String, String> getApiModelValueMembers() {
        return this.apiModelValueMembers;
    }

    public Map<String, String> getFieldComments() {
        return this.fieldComments;
    }
}

