/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.maven.plugin.scan.mojo;

import com.dtyunxi.annotation.LogicColumn;
import com.dtyunxi.annotation.ShardingColumn;
import com.dtyunxi.cube.maven.plugin.scan.constant.Constants;
import com.dtyunxi.cube.maven.plugin.scan.dto.EoVo;
import com.dtyunxi.cube.maven.plugin.scan.util.ClassUtil;
import com.dtyunxi.cube.utils.ReflectUtil;
import com.dtyunxi.eo.CamelToUnderline;
import com.dtyunxi.util.JacksonUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.springframework.util.FileCopyUtils;

@Mojo(name="gen-eo-json", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.COMPILE)
public class EoScanMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    private List<String> classpathElements;
    @Parameter(defaultValue="${project.groupId}", readonly=true)
    private String groupId;
    @Parameter(defaultValue="${project.parent.artifactId}", readonly=true)
    private String artifactId;
    @Parameter(defaultValue="${project.name}", readonly=true)
    private String name;
    @Parameter(defaultValue="${project.version}", readonly=true)
    private String version;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private String outputDirectory;
    private MavenProject mavenProject;
    private Log log;

    public EoScanMojo(MavenProject mavenProject, Log log) {
        if (null == this.classpathElements) {
            try {
                this.classpathElements = mavenProject.getCompileClasspathElements();
            }
            catch (DependencyResolutionRequiredException e) {
                throw new RuntimeException("\u83b7\u53d6CompileClasspathElements\u5f02\u5e38", e);
            }
        }
        this.outputDirectory = mavenProject.getBuild().getOutputDirectory();
        this.groupId = mavenProject.getGroupId();
        this.artifactId = mavenProject.getArtifactId();
        this.name = mavenProject.getName();
        this.version = mavenProject.getVersion();
        this.log = log;
        this.mavenProject = mavenProject;
    }

    public void execute() {
        List<Class> classList = ClassUtil.getAllClasses(this.classpathElements);
        ArrayList<Class> eoClassList = new ArrayList<Class>();
        for (Class clz : classList) {
            Table table = clz.getAnnotation(Table.class);
            if (table == null) continue;
            eoClassList.add(clz);
        }
        EoVo eoVo = this.getEoVoInfo(eoClassList);
        this.getLog().info((CharSequence)("\u626b\u63cfEO\u6570\u91cf\uff1a" + eoVo.getEos().size()));
        File file = new File(this.outputDirectory + File.separator + Constants.RESOURCE_EO_LOCATION);
        File parentFile = file.getParentFile();
        if (parentFile.exists() || parentFile.mkdirs()) {
            try {
                FileCopyUtils.copy((byte[])Objects.requireNonNull(JacksonUtil.toJson((Object)eoVo)).getBytes(StandardCharsets.UTF_8), (File)file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getLog().info((CharSequence)("\u751f\u6210" + Constants.RESOURCE_EO_LOCATION + "\u6587\u4ef6\u6210\u529f"));
        }
    }

    private EoVo getEoVoInfo(List<Class> classes) {
        EoVo eoVo = new EoVo();
        eoVo.setGroupId(this.groupId);
        eoVo.setArtifactId(this.artifactId);
        eoVo.setVersion(this.version);
        ArrayList<EoVo.Eo> eoList = new ArrayList<EoVo.Eo>();
        for (Class eoClass : classes) {
            EoVo.Eo eo = this.getEoInfo(eoClass);
            if (null == eo) continue;
            eoList.add(eo);
        }
        eoVo.setEos(eoList);
        return eoVo;
    }

    private EoVo.Eo getEoInfo(Class eoClass) {
        Table table = eoClass.getAnnotation(Table.class);
        if (null == table) {
            this.getLog().info((CharSequence)(eoClass.getCanonicalName() + "\u7f3a\u5c11@Table\u6ce8\u89e3"));
            return null;
        }
        EoVo.Eo eo = new EoVo.Eo();
        eo.setCode(eoClass.getCanonicalName());
        eo.setName(table.name().toLowerCase());
        eo.setDescr(null);
        ShardingColumn shardingColumn = null;
        if (eoClass.isAnnotationPresent(ShardingColumn.class)) {
            shardingColumn = eoClass.getAnnotation(ShardingColumn.class);
            eo.setShardingColumnName(shardingColumn.name());
        } else {
            Class superClass = eoClass.getSuperclass();
            if (superClass.getSimpleName().contains("Std") && superClass.getSimpleName().contains("Eo") && null != (shardingColumn = superClass.getAnnotation(ShardingColumn.class))) {
                eo.setShardingColumnName(shardingColumn.name());
            }
        }
        HashSet<String> columnSet = new HashSet<String>();
        List fields = ReflectUtil.getAllFields((Class)eoClass);
        ArrayList<EoVo.Eo.EoAttribute> eoAttributeList = new ArrayList<EoVo.Eo.EoAttribute>();
        for (Field field : fields) {
            EoVo.Eo.EoAttribute column = this.getEoAttributeInfo(field);
            if (null == column || columnSet.contains(column.getCode())) continue;
            eoAttributeList.add(column);
            columnSet.add(column.getCode());
            if (!StringUtils.isBlank((CharSequence)eo.getLogicColumnName()) || !field.isAnnotationPresent(LogicColumn.class)) continue;
            LogicColumn logicColumn = field.getAnnotation(LogicColumn.class);
            if (StringUtils.isNotBlank((CharSequence)logicColumn.name())) {
                eo.setLogicColumnName(logicColumn.name());
                continue;
            }
            eo.setLogicColumnName(field.getName());
        }
        eo.setAttributes(eoAttributeList);
        return eo;
    }

    private EoVo.Eo.EoAttribute getEoAttributeInfo(Field field) {
        if (null == field) {
            return null;
        }
        EoVo.Eo.EoAttribute eoAttribute = new EoVo.Eo.EoAttribute();
        Column column = field.getAnnotation(Column.class);
        if (null == column) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)column.name())) {
            eoAttribute.setCode(column.name());
        } else {
            eoAttribute.setCode(CamelToUnderline.camelToUnderline((String)field.getName()));
        }
        eoAttribute.setName(null);
        eoAttribute.setDataType(field.getType().getSimpleName());
        if (String.class.equals(field.getType())) {
            eoAttribute.setLength(column.length());
        }
        eoAttribute.setIsNullable(column.nullable() ? 1 : 0);
        if (field.isAnnotationPresent(Id.class)) {
            eoAttribute.setIsPk(1);
        } else {
            eoAttribute.setIsPk(0);
        }
        return eoAttribute;
    }
}

