/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.maven.plugin.scan.util;

import com.dtyunxi.cube.maven.plugin.scan.util.ConfigUtils;
import com.dtyunxi.cube.maven.plugin.scan.util.ScanJarClzUtil;
import java.io.File;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class ClassUtil {
    public static List<Class> getAllClasses(List<String> compileClasspathElements) {
        URLClassLoader classLoader = Objects.requireNonNull((URLClassLoader)ClassUtils.getDefaultClassLoader(), "\u7c7b\u52a0\u8f7d\u5668\u4e3a\u7a7a");
        compileClasspathElements.forEach(e -> ConfigUtils.addURLToClassLoad(classLoader, e));
        List<Class<?>> jarClass = ScanJarClzUtil.getJarClass(compileClasspathElements, "dtyunxi", classLoader);
        List<Class> classes = compileClasspathElements.stream().filter(classpath -> new File((String)classpath).isDirectory()).flatMap(classpath -> ConfigUtils.getClasses(new File((String)classpath).getAbsolutePath().length(), new File((String)classpath), classLoader).stream()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(jarClass)) {
            classes.addAll(jarClass);
        }
        return classes;
    }
}

