/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.extension.config;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.enhance.extension.CubeExt;
import com.dtyunxi.cube.enhance.extension.ICubeExtension;
import com.dtyunxi.cube.enhance.param.ICubeParam;
import com.dtyunxi.cube.starter.extension.BizIdContext;
import com.dtyunxi.cube.starter.extension.bid.Converter;
import com.dtyunxi.cube.starter.extension.reader.ConfReader;
import com.dtyunxi.cube.starter.extension.reader.IConfReader;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.NestedExceptionUtils;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public class ConfBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
PriorityOrdered {
    public static final Map<String, List<Converter<?, ?>>> CONVERTER_MAP = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(ConfBeanPostProcessor.class);
    private BeanFactory beanFactory;

    public Object postProcessAfterInitialization(@Nonnull Object bean, String beanName) throws BeansException {
        Class beanClass = AopProxyUtils.ultimateTargetClass((Object)bean);
        Object target = AopUtils.isAopProxy((Object)bean) ? AopProxyUtils.getSingletonTarget((Object)bean) : bean;
        ReflectionUtils.doWithFields((Class)beanClass, field -> {
            Class<?> cubeFieldClazz = field.getType();
            if (ICubeParam.class.isAssignableFrom(cubeFieldClazz)) {
                this.injectParam(beanClass, target, field, cubeFieldClazz);
            } else if (ICubeExtension.class.isAssignableFrom(cubeFieldClazz)) {
                this.injectExtension(beanClass, target, field, cubeFieldClazz);
            }
        }, field -> field.isAnnotationPresent(CubeResource.class));
        if (bean instanceof Converter) {
            Converter converter = (Converter)bean;
            CONVERTER_MAP.computeIfAbsent(converter.getSourceClazz().getTypeName(), k -> new ArrayList()).add(converter);
        }
        return bean;
    }

    private void injectParam(Class<?> beanClass, Object target, Field field, final Class<?> cubeFieldClazz) {
        Method readMethod;
        try {
            readMethod = ConfReader.class.getDeclaredMethod("read", Class.class, BizIdContext.class, String.class);
        }
        catch (NoSuchMethodException e) {
            throw new BizException("\u627e\u4e0d\u5230read(Class.class, BizIdContext.class, String.class)\u65b9\u6cd5");
        }
        Object proxy = Proxy.newProxyInstance(cubeFieldClazz.getClassLoader(), new Class[]{cubeFieldClazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (Object.class.equals(method.getDeclaringClass())) {
                    return method.invoke((Object)this, args);
                }
                Object value = null;
                if ("getValue".equals(method.getName())) {
                    String bizCode = null != args && args.length > 0 ? String.valueOf(args[0]) : null;
                    try {
                        value = readMethod.invoke(ConfBeanPostProcessor.this.beanFactory.getBean(IConfReader.class), cubeFieldClazz, new BizIdContext(), bizCode);
                    }
                    catch (InvocationTargetException ex) {
                        throw NestedExceptionUtils.getMostSpecificCause((Throwable)ex);
                    }
                }
                return value;
            }
        });
        ReflectionUtils.makeAccessible((Field)field);
        try {
            field.set(target, proxy);
        }
        catch (IllegalAccessException e) {
            logger.warn("\u6ce8\u5165{}\u7684{}\u5b57\u6bb5\u5931\u8d25:{}", new Object[]{beanClass.getCanonicalName(), field.getName(), e.getMessage()});
        }
    }

    private void injectExtension(Class<?> beanClass, Object target, Field field, final Class<?> cubeFieldClazz) {
        Object proxy = Proxy.newProxyInstance(cubeFieldClazz.getClassLoader(), new Class[]{cubeFieldClazz}, new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                bt = System.currentTimeMillis();
                try {
                    if (Object.class.equals(method.getDeclaringClass())) {
                        var6_5 = method.invoke((Object)this, args);
                        return var6_5;
                    }
                    beans = ((ConfReader)ConfBeanPostProcessor.access$000(ConfBeanPostProcessor.this).getBean(ConfReader.class)).readListExtImpl(cubeFieldClazz, new BizIdContext());
                    if (CollectionUtils.isEmpty(beans)) {
                        var7_7 = null;
                        return var7_7;
                    }
                    if (beans.size() == 1) {
                        try {
                            var7_8 = method.invoke(beans.get(0), args);
                            return var7_8;
                        }
                        catch (InvocationTargetException e) {
                            throw NestedExceptionUtils.getMostSpecificCause((Throwable)e);
                        }
                    }
                    annotation = cubeFieldClazz.getAnnotation(CubeExt.class);
                    if (annotation != null) {
                        if (!CubeExt.ExecMechanism.SERIAL.equals((Object)annotation.execMechanism())) {
                            if (CubeExt.ExecMechanism.RUN_IN_POOL.equals((Object)annotation.execMechanism())) {
                                tasks = new ArrayList<Callable<Object>>();
                                var9_14 = beans.iterator();
                                while (true) {
                                    if (!var9_14.hasNext()) {
                                        ((ThreadPoolExecutor)ConfBeanPostProcessor.access$000(ConfBeanPostProcessor.this).getBean(ThreadPoolExecutor.class)).invokeAny(tasks, 1L, TimeUnit.MINUTES);
                                        var9_14 = null;
                                        return var9_14;
                                    }
                                    bean = var9_14.next();
                                    tasks.add((Callable<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$invoke$0(java.lang.reflect.Method java.lang.Object java.lang.Object[] ), ()Ljava/lang/Object;)((Method)method, bean, (Object[])args));
                                }
                            } else {
                                ** GOTO lbl-1000
                            }
                        }
                    } else lbl-1000:
                    // 3 sources

                    {
                        var7_10 = null;
                        return var7_10;
                    }
                    result = null;
                    var9_13 = beans.iterator();
                }
                finally {
                    ConfBeanPostProcessor.access$100().debug("injectExtension\u8bfb\u53d6\u914d\u7f6e\u9879\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - bt));
                }
                while (true) {
                    if (!var9_13.hasNext()) {
                        return result;
                    }
                    bean = var9_13.next();
                    try {
                        result = method.invoke(bean, args);
                    }
                    catch (InvocationTargetException e) {
                        if (CubeExt.AbortPolicy.BREAK.equals((Object)annotation.abortPolicy())) {
                            throw NestedExceptionUtils.getMostSpecificCause((Throwable)e);
                        }
                        ConfBeanPostProcessor.access$100().warn("\u987a\u5e8f\u6267\u884c\u6709\u5f02\u5e38,\u4e0d\u5904\u7406\u5f02\u5e38\u5f80\u4e0b\u6267\u884c", e.getCause());
                        continue;
                    }
                    break;
                }
            }

            private static /* synthetic */ Object lambda$invoke$0(Method method, Object bean, Object[] args) throws Exception {
                try {
                    return method.invoke(bean, args);
                }
                catch (InvocationTargetException e) {
                    logger.warn("\u5e76\u884c\u6267\u884c\u6709\u5f02\u5e38\uff0c\u4e0d\u5904\u7406\u5f02\u5e38\u5f80\u4e0b\u6267\u884c", e.getCause());
                    return null;
                }
            }
        });
        ReflectionUtils.makeAccessible((Field)field);
        try {
            field.set(target, proxy);
        }
        catch (IllegalAccessException e) {
            throw new BizException("\u6ce8\u5165" + beanClass.getCanonicalName() + "\u7684" + field.getName() + "\u5b57\u6bb5\u5931\u8d25:" + e.getMessage());
        }
    }

    public void setBeanFactory(@Nonnull BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

