/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.extension.config;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.starter.extension.config.SettingLocalCache;
import com.dtyunxi.cube.starter.extension.constants.EnhanceConstants;
import com.dtyunxi.huieryun.starter.localcache.LocalCacheManager;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.ConfigQueryReq;
import com.dtyunxi.yundt.cube.center.data.api.enums.SettingLevelEnum;
import com.dtyunxi.yundt.cube.center.data.dto.LocalCacheUpdaterDto;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableCaching
public class ConfKeyGenerationConfig {
    private static final Logger logger = LoggerFactory.getLogger(ConfKeyGenerationConfig.class);

    public ConfKeyGenerationConfig(LocalCacheManager localCacheManager) {
        String[] cacheNames;
        for (String cacheName : cacheNames = new String[]{"idConfCache", "spaceConfCache", "tenantConfCache", "globalConfCache"}) {
            localCacheManager.getCacheMap().put(cacheName, new SettingLocalCache(cacheName, localCacheManager.getProperties(), localCacheManager.getCacheService()));
        }
    }

    @Bean
    public KeyGenerator idKeyGenerator() {
        return (target, method, params) -> {
            if (params == null) {
                throw new BizException("\u67e5\u8be2\u914d\u7f6e\u9879\u503c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Object param = params[0];
            if (param instanceof ConfigQueryReq) {
                ConfigQueryReq configQueryReq = (ConfigQueryReq)param;
                return EnhanceConstants.combineKey(configQueryReq.getCode(), SettingLevelEnum.ID.getValue(), configQueryReq.getBidIdCode());
            }
            if (param instanceof LocalCacheUpdaterDto) {
                LocalCacheUpdaterDto localCacheUpdaterDto = (LocalCacheUpdaterDto)param;
                return EnhanceConstants.combineKey(localCacheUpdaterDto.getSettingCode(), SettingLevelEnum.ID.getValue(), localCacheUpdaterDto.getBizId());
            }
            return method.getName() + "[" + Arrays.asList(params).toString() + "]";
        };
    }

    @Bean
    public KeyGenerator spaceKeyGenerator() {
        return (target, method, params) -> {
            if (params == null) {
                throw new BizException("\u67e5\u8be2\u914d\u7f6e\u9879\u503c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Object param = params[0];
            if (param instanceof ConfigQueryReq) {
                ConfigQueryReq configQueryReq = (ConfigQueryReq)param;
                Long requestInstanceId = ServiceContext.getContext().getRequestInstanceId();
                if (requestInstanceId == null && configQueryReq.getBizIdContext() != null) {
                    requestInstanceId = configQueryReq.getBizIdContext().getReqInstanceId();
                    logger.info("\u8bf7\u6c42header\u4e2d\u6ca1\u6709instanceId,\u5c1d\u8bd5\u4f7f\u7528\u8bf7\u6c42\u4e2d\u7684instanceId:{}", (Object)requestInstanceId);
                }
                return EnhanceConstants.combineKey(configQueryReq.getCode(), SettingLevelEnum.SPACE.getValue(), requestInstanceId);
            }
            if (param instanceof LocalCacheUpdaterDto) {
                LocalCacheUpdaterDto localCacheUpdaterDto = (LocalCacheUpdaterDto)param;
                return EnhanceConstants.combineKey(localCacheUpdaterDto.getSettingCode(), SettingLevelEnum.SPACE.getValue(), localCacheUpdaterDto.getInstanceId());
            }
            return method.getName() + "[" + Arrays.asList(params).toString() + "]";
        };
    }

    @Bean
    public KeyGenerator tenantKeyGenerator() {
        return (target, method, params) -> {
            if (params == null) {
                throw new BizException("\u67e5\u8be2\u914d\u7f6e\u9879\u503c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Object param = params[0];
            if (param instanceof ConfigQueryReq) {
                ConfigQueryReq configQueryReq = (ConfigQueryReq)param;
                Long requestTenantId = ServiceContext.getContext().getRequestTenantId();
                if (requestTenantId == null && configQueryReq.getBizIdContext() != null) {
                    requestTenantId = configQueryReq.getBizIdContext().getReqTenantId();
                    logger.info("\u8bf7\u6c42header\u4e2d\u6ca1\u6709 tenantId ,\u5c1d\u8bd5\u4f7f\u7528\u8bf7\u6c42\u4e2d\u7684 tenantId :{}", (Object)requestTenantId);
                }
                return EnhanceConstants.combineKey(configQueryReq.getCode(), SettingLevelEnum.TENANT.getValue(), requestTenantId);
            }
            if (param instanceof LocalCacheUpdaterDto) {
                LocalCacheUpdaterDto localCacheUpdaterDto = (LocalCacheUpdaterDto)param;
                return EnhanceConstants.combineKey(localCacheUpdaterDto.getSettingCode(), SettingLevelEnum.TENANT.getValue(), localCacheUpdaterDto.getTenantId());
            }
            return method.getName() + "[" + Arrays.asList(params).toString() + "]";
        };
    }

    @Bean
    public KeyGenerator globalKeyGenerator() {
        return (target, method, params) -> {
            if (params == null) {
                throw new BizException("\u67e5\u8be2\u914d\u7f6e\u9879\u503c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Object param = params[0];
            if (param instanceof ConfigQueryReq) {
                ConfigQueryReq configQueryReq = (ConfigQueryReq)param;
                return EnhanceConstants.combineKey(configQueryReq.getCode(), SettingLevelEnum.GLOBAL.getValue());
            }
            if (param instanceof LocalCacheUpdaterDto) {
                LocalCacheUpdaterDto localCacheUpdaterDto = (LocalCacheUpdaterDto)param;
                return EnhanceConstants.combineKey(localCacheUpdaterDto.getSettingCode(), SettingLevelEnum.GLOBAL.getValue());
            }
            return method.getName() + "[" + Arrays.asList(params).toString() + "]";
        };
    }
}

