/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.extension.scan;

import com.dtyunxi.cube.enhance.extension.ICubeExtension;
import com.dtyunxi.cube.starter.extension.dto.CubeCenter;
import com.dtyunxi.cube.starter.extension.dto.CubeExtensionClass;
import com.dtyunxi.cube.starter.extension.dto.CubeExtensionIntf;
import com.dtyunxi.util.SpringBeanUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeExtensionScanner {
    private static final Logger logger = LoggerFactory.getLogger(CubeExtensionScanner.class);

    public static CubeCenter scan(String ... basePackages) {
        CubeCenter cubeCenter = new CubeCenter();
        cubeCenter.setCubeCode("todo").setCubeName("TODO").setCubeDesc("TODO");
        Map<CubeExtensionIntf, List<CubeExtensionClass>> extensions = CubeExtensionScanner.scanExtensions(basePackages);
        cubeCenter.setExtensions(extensions);
        return cubeCenter;
    }

    private static Map<CubeExtensionIntf, List<CubeExtensionClass>> scanExtensions(String[] basePackages) {
        HashSet<CubeExtensionClass> extensionClasses = new HashSet<CubeExtensionClass>(128);
        for (String basePackage : basePackages) {
            Set<CubeExtensionClass> packageExtensionClasses = CubeExtensionScanner.scanPackageExtension(basePackage);
            if (!CollectionUtils.isNotEmpty(packageExtensionClasses)) continue;
            extensionClasses.addAll(packageExtensionClasses);
        }
        HashMap<CubeExtensionIntf, List<CubeExtensionClass>> extensionMap = new HashMap<CubeExtensionIntf, List<CubeExtensionClass>>(128);
        for (CubeExtensionClass extensionClass : extensionClasses) {
            List<CubeExtensionIntf> extensionIntfs = CubeExtensionScanner.readExtensionIntf(extensionClass);
            if (extensionIntfs == null) {
                logger.warn("{} \u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6269\u5c55\u70b9\u5b9a\u4e49", (Object)extensionClass.getClazz().getCanonicalName());
                continue;
            }
            for (CubeExtensionIntf extensionIntf : extensionIntfs) {
                List cubeExtensionClasses = extensionMap.getOrDefault(extensionIntf, new ArrayList(4));
                cubeExtensionClasses.add(extensionClass);
                extensionMap.put(extensionIntf, cubeExtensionClasses);
            }
        }
        return extensionMap;
    }

    private static List<CubeExtensionIntf> readExtensionIntf(CubeExtensionClass extensionClass) {
        ArrayList<CubeExtensionIntf> intfs = new ArrayList<CubeExtensionIntf>(2);
        Class<?>[] interfaces = extensionClass.getClazz().getInterfaces();
        if (interfaces != null && interfaces.length > 0) {
            for (Class<?> intf : interfaces) {
                if (!ICubeExtension.class.isAssignableFrom(intf)) continue;
                try {
                    intfs.add(new CubeExtensionIntf(intf));
                }
                catch (Exception e) {
                    logger.warn("{} \u6ca1\u6709\u7ee7\u627f ICubeExtension", intf);
                }
            }
        }
        return intfs;
    }

    private static Set<CubeExtensionClass> scanPackageExtension(String basePackage) {
        HashSet<CubeExtensionClass> extensionClasses = new HashSet<CubeExtensionClass>(64);
        Map beanInstances = SpringBeanUtil.getApplicationContext().getBeansOfType(ICubeExtension.class);
        for (ICubeExtension beanInstance : beanInstances.values()) {
            extensionClasses.add(new CubeExtensionClass(beanInstance.getClass()));
        }
        return extensionClasses;
    }
}

