/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.notifier.starter.publisher.rest;

import com.dtyunxi.cube.notifier.starter.publisher.rest.RestRibbonConfig;
import com.dtyunxi.cube.notifier.starter.publisher.rest.event.RetryRefreshEvent;
import com.dtyunxi.cube.utils.threads.CommonThreadPool;
import com.dtyunxi.cube.utils.threads.pattens.ConsumerWorker;
import com.dtyunxi.cube.utils.threads.pattens.ProdConsuPatten;
import com.dtyunxi.cube.utils.threads.pattens.ProductQueueStore;
import com.dtyunxi.cube.utils.threads.pattens.ProductStore;
import com.dtyunxi.rest.RestResponse;
import feign.Feign;
import feign.Request;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.openfeign.support.ResponseEntityDecoder;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

public abstract class AbstractRestRulePublishProcessor<FEIGN_API>
implements ApplicationContextAware,
ConsumerWorker<CallBack> {
    private static Logger logger = LoggerFactory.getLogger(AbstractRestRulePublishProcessor.class);
    private CommonThreadPool pool;
    private ProdConsuPatten dispatcher;
    private ProductStore store;
    private ApplicationContext applicationContext;
    private RestRibbonConfig restRibbonConfig;
    private DiscoveryClient discoveryClient;
    private String receiverServiceId;
    private Class<FEIGN_API> feignApiClass;

    public AbstractRestRulePublishProcessor(Class<FEIGN_API> feignApiClass, RestRibbonConfig restRibbonConfig, String receiverServer, DiscoveryClient discoveryClient) {
        this.receiverServiceId = receiverServer;
        this.discoveryClient = discoveryClient;
        this.restRibbonConfig = restRibbonConfig;
        this.pool = new CommonThreadPool();
        this.store = new ProductQueueStore(5000);
        this.dispatcher = new ProdConsuPatten(this.pool, this.store, (ConsumerWorker)this, null);
        this.dispatcher.start();
        this.feignApiClass = feignApiClass;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Decoder feignDecoder() {
        HttpMessageConverters converters = new HttpMessageConverters(new HttpMessageConverter[]{new MappingJackson2HttpMessageConverter()});
        return new ResponseEntityDecoder((Decoder)new SpringDecoder(() -> converters));
    }

    public Encoder feignEncoder() {
        HttpMessageConverters converters = new HttpMessageConverters(new HttpMessageConverter[]{new MappingJackson2HttpMessageConverter()});
        return new SpringEncoder(() -> converters);
    }

    public FEIGN_API getApiInstance(String uri, Class<FEIGN_API> feignApiClass) {
        return (FEIGN_API)Feign.builder().decoder(this.feignDecoder()).encoder(this.feignEncoder()).options(new Request.Options(this.restRibbonConfig.getRibbonConnectTimeout(), this.restRibbonConfig.getRibbonReadTimeout())).retryer((Retryer)new Retryer.Default(this.restRibbonConfig.getPeriod(), this.restRibbonConfig.getMaxPeriod(), this.restRibbonConfig.getMaxAttempts())).target(feignApiClass, this.restRibbonConfig.getProtocol() + "://" + uri);
    }

    public void process(CallBack<FEIGN_API> callBack) {
        try {
            this.dispatcher.put(callBack);
        }
        catch (InterruptedException e) {
            logger.info("rest\u901a\u77e5\u5237\u65b0\u653e\u5165\u6d88\u8d39\u961f\u5217\u5f02\u5e38\uff1a", (Object)this.receiverServiceId, (Object)e);
        }
    }

    public void doWork(CallBack callBack) {
        try {
            int pos;
            List serviceInstances = this.discoveryClient.getInstances(this.receiverServiceId);
            CompletableFuture[] results = new CompletableFuture[serviceInstances.size()];
            ArrayList gatewayConfigRefreshApis = new ArrayList(serviceInstances.size());
            for (pos = 0; pos < serviceInstances.size(); ++pos) {
                ServiceInstance instance = (ServiceInstance)serviceInstances.get(pos);
                gatewayConfigRefreshApis.add(this.getApiInstance(instance.getHost() + ":" + instance.getPort(), this.feignApiClass));
                int finalPos = pos;
                results[pos] = CompletableFuture.supplyAsync(() -> callBack.onEvent(gatewayConfigRefreshApis.get(finalPos)));
            }
            for (pos = 0; pos < results.length; ++pos) {
                CompletableFuture result = results[pos];
                try {
                    RestResponse restResponse = (RestResponse)result.get();
                    if ("0".equals(restResponse.getResultCode())) continue;
                    this.applicationContext.publishEvent(new RetryRefreshEvent(this, gatewayConfigRefreshApis.get(pos), callBack, 1));
                    continue;
                }
                catch (InterruptedException e) {
                    logger.info("\u6536\u96c6\u914d\u7f6e\u5237\u65b0\u901a\u77e5\u7ed3\u679c\u8fdb\u7a0b\u4e2d\u65ad\u5f02\u5e38\uff1a", (Throwable)e);
                    this.applicationContext.publishEvent(new RetryRefreshEvent(this, gatewayConfigRefreshApis.get(pos), callBack, 1));
                    continue;
                }
                catch (ExecutionException e) {
                    logger.info("\u6536\u96c6\u914d\u7f6e\u5237\u65b0\u901a\u77e5\u7ed3\u679c\u6267\u884c\u5f02\u5e38\uff1a", (Throwable)e);
                    this.applicationContext.publishEvent(new RetryRefreshEvent(this, gatewayConfigRefreshApis.get(pos), callBack, 1));
                }
            }
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u670d\u52a1{}\u7684\u5b9e\u4f8b\u5f02\u5e38\uff1a", (Object)this.receiverServiceId, (Object)e);
        }
    }

    public static interface CallBack<FEIGN_API> {
        public RestResponse<Void> onEvent(FEIGN_API var1);
    }
}

