/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils.bean;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.base.Strings;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;

public class ObjectHelper {
    static final ObjectMapper jsonMapper = new ObjectMapper();
    static final XmlMapper xmlMapper;

    private ObjectHelper() {
    }

    public static boolean isString(Object obj) {
        return obj instanceof String;
    }

    public static boolean isInteger(Object obj) {
        return obj instanceof Integer || obj instanceof Long;
    }

    public static boolean isFloat(Object obj) {
        return obj instanceof Double || obj instanceof Float;
    }

    public static boolean isNumber(Object obj) {
        return ObjectHelper.isInteger(obj) || ObjectHelper.isFloat(obj);
    }

    public static boolean isDate(Object obj) {
        return obj instanceof Date;
    }

    public static Map<String, Object> bean2Map(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (obj == null) {
            return null;
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if ("class".equals(key)) continue;
                Method getter = property.getReadMethod();
                Object value = getter.invoke(obj, new Object[0]);
                map.put(key, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    public static String bean2Json(Object bean) {
        if (bean == null) {
            return "{}";
        }
        if (bean instanceof String) {
            return (String)bean;
        }
        try {
            return jsonMapper.writeValueAsString(bean);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static <T> T Json2Bean(String json, Class<T> cls) {
        if (Strings.isNullOrEmpty((String)json)) {
            return null;
        }
        try {
            return (T)jsonMapper.readValue(json, cls);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static <T> T Json2Bean(String json, TypeReference cls) {
        if (Strings.isNullOrEmpty((String)json)) {
            return null;
        }
        try {
            return (T)jsonMapper.readValue(json, cls);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static String Bean2xml(Object bean) throws Exception {
        try {
            return xmlMapper.writeValueAsString(bean);
        }
        catch (JsonProcessingException ex) {
            throw new Exception(ex.getMessage(), ex);
        }
    }

    public static <T> T Xml2Bean(String xml, Class<T> cls) throws Exception {
        if (Strings.isNullOrEmpty((String)xml)) {
            return null;
        }
        try {
            return (T)xmlMapper.readValue(xml, cls);
        }
        catch (JsonProcessingException ex) {
            throw new Exception(ex.getMessage(), ex);
        }
    }

    public static boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String) {
            if (((String)o).trim().length() == 0) {
                return true;
            }
        } else if (o instanceof Collection) {
            if (((Collection)o).isEmpty()) {
                return true;
            }
        } else if (o.getClass().isArray()) {
            if (((Object[])o).length == 0) {
                return true;
            }
        } else if (o instanceof Map) {
            if (((Map)o).isEmpty()) {
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    public static boolean isNotEmpty(Object o) {
        return !ObjectHelper.isEmpty(o);
    }

    public static <T> void mapToBean(Map map, T obj) {
        if (map == null || obj == null) {
            return;
        }
        try {
            BeanUtils.populate(obj, (Map)map);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isFieldExists(String field, Class<?> c) {
        if (c == null) {
            return false;
        }
        Field[] fields = c.getDeclaredFields();
        boolean exists = false;
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals(field)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            exists = ObjectHelper.isFieldExists(field, c.getSuperclass());
        }
        return exists;
    }

    static {
        jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JacksonXmlModule module = new JacksonXmlModule();
        xmlMapper = new XmlMapper(module);
    }
}

