/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils.threads;

import com.dtyunxi.cube.utils.threads.LifeCyle;
import com.dtyunxi.cube.utils.threads.LifeCyleStatus;
import com.dtyunxi.cube.utils.threads.ThreadPool;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonThreadPool
implements LifeCyle,
ThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonThreadPool.class);
    private ExecutorService threadPool;
    private int size = 10;
    private LifeCyleStatus status = LifeCyleStatus.NEW;

    @Override
    public synchronized void execute(Runnable worker) {
        if (this.status != LifeCyleStatus.RUNNING) {
            this.start();
        }
        this.threadPool.execute(worker);
    }

    @Override
    public synchronized void start() {
        if (this.status != LifeCyleStatus.RUNNING) {
            LOGGER.info("Start CommonThreadPool......");
            this.status = LifeCyleStatus.RUNNING;
            LOGGER.info("Create CommonThreadPool......");
            this.threadPool = Executors.newFixedThreadPool(this.size);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.status != LifeCyleStatus.RUNNING) {
            return;
        }
        LOGGER.info("Stopping CommonThreadPool......");
        CommonThreadPool.shutdownAndAwaitTermination(this.threadPool);
        this.threadPool = null;
        this.status = LifeCyleStatus.STOPPED;
        LOGGER.info("Stop CommonThreadPool end! ");
    }

    @Override
    public void pause() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public LifeCyleStatus getStatus() {
        return this.status;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public static void shutdownAndAwaitTermination(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(4L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                pool.awaitTermination(4L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
        }
    }
}

