/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils.codec;

import com.dtyunxi.cube.utils.codec.AESUtil;
import com.dtyunxi.cube.utils.codec.Secret;
import org.springframework.util.ReflectionUtils;

public abstract class SecretUtils {
    private static boolean isEncryptedValue(String value) {
        if (value == null) {
            return false;
        }
        String trimmedValue = value.trim();
        return trimmedValue.startsWith("ENC(") && trimmedValue.endsWith(")");
    }

    private static String getInnerEncryptedValue(String value) {
        return value.substring("ENC(".length(), value.length() - ")".length());
    }

    public static <T> T encryptSecretField(Class<T> clazz, T object, String key) {
        ReflectionUtils.doWithFields(clazz, field -> {
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            String value = (String)field.get(object);
            field.set(object, SecretUtils.encrypt(value, key));
            if (!accessible) {
                field.setAccessible(false);
            }
        }, field -> field.isAnnotationPresent(Secret.class));
        return object;
    }

    public static <T> T decryptSecretField(Class<T> clazz, T object, String key) {
        ReflectionUtils.doWithFields(clazz, field -> {
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            String value = (String)field.get(object);
            field.set(object, SecretUtils.decrypt(value, key));
            if (!accessible) {
                field.setAccessible(false);
            }
        }, field -> field.isAnnotationPresent(Secret.class));
        return object;
    }

    public static String encrypt(String value, String key) {
        if (value != null && !SecretUtils.isEncryptedValue(value)) {
            try {
                value = "ENC(" + AESUtil.aesEncrypt(value, key) + ")";
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return value;
    }

    public static String decrypt(String value, String key) {
        if (SecretUtils.isEncryptedValue(value)) {
            try {
                value = AESUtil.aesDecrypt(SecretUtils.getInnerEncryptedValue(value), key);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return value;
    }
}

