/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils.tree;

import com.dtyunxi.cube.utils.tree.ITreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TreeWorkshop<T extends ITreeNode> {
    public List<T> buildTreeByList(List<T> src) {
        HashMap<String, List<String>> map4parent = new HashMap<String, List<String>>();
        HashMap<String, ITreeNode> map4node = new HashMap<String, ITreeNode>();
        ArrayList<String> rootKeys = new ArrayList<String>();
        for (ITreeNode t : src) {
            ArrayList<String> childrenList;
            if (t.isRootNode().booleanValue()) {
                rootKeys.add(t.getKey());
            }
            if (null == (childrenList = (ArrayList<String>)map4parent.get(t.getParentKey()))) {
                childrenList = new ArrayList<String>();
            }
            childrenList.add(t.getKey());
            map4parent.put(t.getParentKey(), childrenList);
            map4node.put(t.getKey(), t);
        }
        ArrayList resultList = new ArrayList();
        for (String rootKey : rootKeys) {
            Object root = this.buildNode(rootKey, map4parent, map4node);
            resultList.add(root);
        }
        Collections.sort(resultList);
        return resultList;
    }

    private T buildNode(String parentKey, Map<String, List<String>> map4parent, Map<String, T> map4node) {
        List<String> childrenKeys;
        ITreeNode srcParent = (ITreeNode)map4node.get(parentKey);
        if (null == srcParent.getChildren()) {
            srcParent.setChildren(new ArrayList());
        }
        if ((childrenKeys = map4parent.get(parentKey)) != null && childrenKeys.size() > 0) {
            for (String childrenKey : childrenKeys) {
                T child = this.buildNode(childrenKey, map4parent, map4node);
                srcParent.addChild(child);
            }
            Collections.sort(srcParent.getChildren());
        }
        return (T)srcParent;
    }
}

