/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.cache.redis.impl;

import cn.hutool.core.map.MapUtil;
import com.dtyunxi.huieryun.cache.api.AbstractCacheService;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.cache.api.IRedisCacheService;
import com.dtyunxi.huieryun.cache.api.IRedisSubProcessor;
import com.dtyunxi.huieryun.cache.api.model.GeoCoordinate;
import com.dtyunxi.huieryun.cache.api.model.GeoRadiusParam;
import com.dtyunxi.huieryun.cache.api.model.GeoRadiusResponse;
import com.dtyunxi.huieryun.cache.api.model.GeoUnit;
import com.dtyunxi.huieryun.cache.api.model.ScanResult;
import com.dtyunxi.huieryun.cache.api.model.Tuple;
import com.dtyunxi.huieryun.cache.redis.config.RedisFactoryUtils;
import com.dtyunxi.huieryun.cache.redis.impl.GeoRadiusParamToCommand;
import com.dtyunxi.huieryun.cache.vo.CacheRegistryVo;
import com.dtyunxi.util.JacksonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.CustomStringRedisTemplate;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.query.SortQuery;
import org.springframework.data.redis.core.query.SortQueryBuilder;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.util.CollectionUtils;

public class RedisCacheServiceImpl
extends AbstractCacheService
implements ICacheService,
IRedisCacheService {
    private static final Logger logger = LoggerFactory.getLogger(RedisCacheServiceImpl.class);
    private CustomStringRedisTemplate stringRedisTemplate;

    public RedisCacheServiceImpl() {
    }

    public RedisCacheServiceImpl(CustomStringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public void init(String group, CacheRegistryVo cacheRegistryVo) {
        super.init(group, cacheRegistryVo);
        LettuceConnectionFactory redisConnectionFactory = RedisFactoryUtils.getConnectionFactory(cacheRegistryVo);
        this.stringRedisTemplate = new CustomStringRedisTemplate((RedisConnectionFactory)redisConnectionFactory);
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getDefaultGroup() {
        return this.group;
    }

    public boolean exists(String group, String key) {
        String combineKey = this.combineKey(group, key);
        Boolean exists = this.stringRedisTemplate.hasKey(combineKey);
        return exists == null ? false : exists;
    }

    public String type(String group, String key) {
        String combineKey = this.combineKey(group, key);
        DataType type = this.stringRedisTemplate.type(combineKey);
        return type == null ? null : type.code();
    }

    public boolean rename(String group, String oldKey, String newKey) {
        String oldCombineKey = this.combineKey(group, oldKey);
        String newCombineKey = this.combineKey(group, newKey);
        this.stringRedisTemplate.rename(oldCombineKey, newCombineKey);
        return true;
    }

    public Long renamenx(String group, String oldKey, String newKey) {
        String newCombineKey;
        String oldCombineKey = this.combineKey(group, oldKey);
        Boolean result = this.stringRedisTemplate.renameIfAbsent(oldCombineKey, newCombineKey = this.combineKey(group, newKey));
        return Boolean.TRUE.equals(result) ? 1L : 0L;
    }

    public String getrange(String group, String key, long startOffset, long endOffset) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForValue().get((Object)combineKey, startOffset, endOffset);
    }

    public Long decrBy(String group, String key, long decrement) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForValue().increment((Object)combineKey, -decrement);
    }

    public Long strlen(String group, String key) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForValue().size((Object)combineKey);
    }

    public boolean msetnx(String group, Map<String, String> dataMap) {
        Map combineDataMap = this.getCombineDataMap(group, dataMap);
        if (MapUtil.isNotEmpty((Map)combineDataMap)) {
            Boolean result = this.stringRedisTemplate.opsForValue().multiSetIfAbsent(combineDataMap);
            return result == null ? false : result;
        }
        return false;
    }

    public Long setrange(String group, String key, long offset, String value) {
        String combineKey = this.combineKey(group, key);
        this.stringRedisTemplate.opsForValue().set((Object)combineKey, (Object)value, offset);
        return this.stringRedisTemplate.opsForValue().size((Object)combineKey);
    }

    public Long append(String group, String key, String value) {
        String combineKey = this.combineKey(group, key);
        Integer result = this.stringRedisTemplate.opsForValue().append((Object)combineKey, value);
        return result == null ? 0L : result.longValue();
    }

    public String getAndSet(String group, String key, String value) {
        String combineKey = this.combineKey(group, key);
        return (String)this.stringRedisTemplate.opsForValue().getAndSet((Object)combineKey, (Object)value);
    }

    public String lindex(String group, String key, long index) {
        String combineKey = this.combineKey(group, key);
        return (String)this.stringRedisTemplate.opsForList().index((Object)combineKey, index);
    }

    public String rpoplpush(String group, String srckey, String dstkey) {
        String srcCombineKey = this.combineKey(group, srckey);
        String dstCombineKey = this.combineKey(group, dstkey);
        return (String)this.stringRedisTemplate.opsForList().rightPopAndLeftPush((Object)srcCombineKey, (Object)dstCombineKey);
    }

    public List<String> blpop(String group, String[] keys) {
        String[] combineKey = this.combineKeys(group, keys);
        return this.stringRedisTemplate.customListOps().leftPop((String[])combineKey);
    }

    public String blpop(String group, int timeout, String key) {
        String combineKey = this.combineKey(group, key);
        return (String)this.stringRedisTemplate.opsForList().leftPop((Object)combineKey, (long)timeout, TimeUnit.SECONDS);
    }

    public List<String> blpop(String group, int timeout, String[] keys) {
        String[] combineKey = this.combineKeys(group, keys);
        return this.stringRedisTemplate.customListOps().leftPop((String[])combineKey, timeout, TimeUnit.SECONDS);
    }

    public List<String> brpop(String group, String[] keys) {
        String[] combineKey = this.combineKeys(group, keys);
        return this.stringRedisTemplate.customListOps().rightPop((String[])combineKey);
    }

    public String brpop(String group, int timeout, String key) {
        String combineKey = this.combineKey(group, key);
        return (String)this.stringRedisTemplate.opsForList().rightPop((Object)combineKey, (long)timeout, TimeUnit.SECONDS);
    }

    public List<String> brpop(String group, int timeout, String[] keys) {
        String[] combineKey = this.combineKeys(group, keys);
        return this.stringRedisTemplate.customListOps().rightPop((String[])combineKey, timeout, TimeUnit.SECONDS);
    }

    public String brpoplpush(String group, String source, String destination, int timeout) {
        String srcCombineKey = this.combineKey(group, source);
        String dstCombineKey = this.combineKey(group, destination);
        return (String)this.stringRedisTemplate.opsForList().rightPopAndLeftPush((Object)srcCombineKey, (Object)dstCombineKey, (long)timeout, TimeUnit.SECONDS);
    }

    public Long lrem(String group, String key, long count, String value) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForList().remove((Object)combineKey, count, (Object)value);
    }

    public Long llen(String group, String key) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForList().size((Object)combineKey);
    }

    public boolean ltrim(String group, String key, long start, long end) {
        String combineKey = this.combineKey(group, key);
        this.stringRedisTemplate.opsForList().trim((Object)combineKey, start, end);
        return true;
    }

    public String lpop(String group, String key) {
        String combineKey = this.combineKey(group, key);
        return (String)this.stringRedisTemplate.opsForList().leftPop((Object)combineKey);
    }

    public String rpop(String group, String key) {
        String combineKey = this.combineKey(group, key);
        return (String)this.stringRedisTemplate.opsForList().rightPop((Object)combineKey);
    }

    public <T> Long lpushx(String group, String key, List<T> valueList, int seconds) {
        Long result = 0L;
        String combineKey = this.combineKey(group, key);
        if (this.stringRedisTemplate.hasKey(combineKey).booleanValue()) {
            Object[] obj = this.listToArray(valueList);
            result = this.stringRedisTemplate.opsForList().leftPushAll((Object)combineKey, obj);
            if (seconds != 0) {
                this.expire(group, key, seconds);
            }
        }
        return result;
    }

    public <T> Long rpushx(String group, String key, List<T> valueList, int seconds) {
        Long result = 0L;
        String combineKey = this.combineKey(group, key);
        if (this.stringRedisTemplate.hasKey(combineKey).booleanValue()) {
            Object[] obj = this.listToArray(valueList);
            result = this.stringRedisTemplate.opsForList().rightPushAll((Object)combineKey, obj);
            if (seconds != 0) {
                this.expire(group, key, seconds);
            }
        }
        return result;
    }

    public <T> boolean lset(String group, String key, long index, T value) {
        String combineKey = this.combineKey(group, key);
        this.stringRedisTemplate.opsForList().set((Object)combineKey, index, (Object)JacksonUtil.toJson(value));
        return true;
    }

    public Boolean hexists(String group, String key, String field) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForHash().hasKey((Object)combineKey, (Object)field);
    }

    public Long hlen(String group, String key) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForHash().size((Object)combineKey);
    }

    public List<String> hvals(String group, String key) {
        String combineKey = this.combineKey(group, key);
        List objects = this.stringRedisTemplate.opsForHash().values((Object)combineKey);
        return this.objToString(objects);
    }

    public <T> Long hsetnx(String group, String key, String field, T value, int seconds) {
        String combineKey = this.combineKey(group, key);
        boolean result = this.stringRedisTemplate.opsForHash().putIfAbsent((Object)combineKey, (Object)field, (Object)JacksonUtil.toJson(value));
        if (result && seconds != 0) {
            this.expire(group, key, seconds);
        }
        return result ? 1L : 0L;
    }

    public <T> Long sadd(String group, String key, List<T> members, int seconds) {
        String combineKey = this.combineKey(group, key);
        Object[] obj = this.listToArray(members);
        Long result = this.stringRedisTemplate.opsForSet().add((Object)combineKey, obj);
        if (seconds != 0) {
            this.expire(group, key, seconds);
        }
        return result;
    }

    public Set<String> smembers(String group, String key) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForSet().members((Object)combineKey);
    }

    public Long srem(String group, String key, String[] members) {
        Long result = 0L;
        String combineKey = this.combineKey(group, key);
        if (members != null && members.length > 0) {
            result = this.stringRedisTemplate.opsForSet().remove((Object)combineKey, (Object[])members);
        }
        return result;
    }

    public String spop(String group, String key) {
        String combineKey = this.combineKey(group, key);
        return (String)this.stringRedisTemplate.opsForSet().pop((Object)combineKey);
    }

    public Set<String> spop(String group, String key, long count) {
        String combineKey = this.combineKey(group, key);
        List list = this.stringRedisTemplate.opsForSet().pop((Object)combineKey, count);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return new HashSet<String>(list);
        }
        return null;
    }

    public Long smove(String group, String srckey, String dstkey, String member) {
        String combineSrcKey = this.combineKey(group, srckey);
        String combineDstKey = this.combineKey(group, dstkey);
        Boolean result = this.stringRedisTemplate.opsForSet().move((Object)combineSrcKey, (Object)combineDstKey, (Object)member);
        return result != null && result != false ? 1L : 0L;
    }

    public Long scard(String group, String key) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForSet().size((Object)combineKey);
    }

    public Boolean sismember(String group, String key, String member) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForSet().isMember((Object)combineKey, (Object)member);
    }

    public Set<String> sinter(String group, String[] keys) {
        Set set = null;
        if (keys != null && keys.length > 0) {
            String[] combineKeys = this.combineKeys(group, keys);
            set = this.stringRedisTemplate.opsForSet().intersect((Object)combineKeys[0], Arrays.asList(combineKeys));
        }
        return set;
    }

    public Long sinterstore(String group, String dstkey, String[] keys) {
        Long result = null;
        if (keys != null && keys.length > 0) {
            String dstCombineKey = this.combineKey(group, dstkey);
            String[] combineKeys = this.combineKeys(group, keys);
            result = this.stringRedisTemplate.opsForSet().intersectAndStore((Object)combineKeys[0], Arrays.asList(combineKeys), (Object)dstCombineKey);
        }
        return result;
    }

    public Set<String> sunion(String group, String[] keys) {
        Set set = null;
        if (keys != null && keys.length > 0) {
            String[] combineKeys = this.combineKeys(group, keys);
            set = this.stringRedisTemplate.opsForSet().union((Object)combineKeys[0], Arrays.asList(combineKeys));
        }
        return set;
    }

    public Long sunionstore(String group, String dstkey, String[] keys) {
        Long result = null;
        if (keys != null && keys.length > 0) {
            String dstCombineKey = this.combineKey(group, dstkey);
            String[] combineKeys = this.combineKeys(group, keys);
            result = this.stringRedisTemplate.opsForSet().unionAndStore((Object)combineKeys[0], Arrays.asList(combineKeys), (Object)dstCombineKey);
        }
        return result;
    }

    public Set<String> sdiff(String group, String[] keys) {
        Set set = null;
        if (keys != null && keys.length > 0) {
            String[] combineKeys = this.combineKeys(group, keys);
            set = this.stringRedisTemplate.opsForSet().difference((Object)combineKeys[0], Arrays.asList(combineKeys));
        }
        return set;
    }

    public Long sdiffstore(String group, String dstkey, String[] keys) {
        Long result = null;
        if (keys != null && keys.length > 0) {
            String dstCombineKey = this.combineKey(group, dstkey);
            String[] combineKeys = this.combineKeys(group, keys);
            result = this.stringRedisTemplate.opsForSet().differenceAndStore((Object)combineKeys[0], Arrays.asList(combineKeys), (Object)dstCombineKey);
        }
        return result;
    }

    public String srandmember(String group, String key) {
        String combineKey = this.combineKey(group, key);
        return (String)this.stringRedisTemplate.opsForSet().randomMember((Object)combineKey);
    }

    public List<String> srandmember(String group, String key, int count) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForSet().randomMembers((Object)combineKey, (long)count);
    }

    public Double zincrby(String group, String key, double score, String member) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForZSet().incrementScore((Object)combineKey, (Object)member, score);
    }

    public Long zrank(String group, String key, String member) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForZSet().rank((Object)combineKey, (Object)member);
    }

    public Long zrevrank(String group, String key, String member) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForZSet().reverseRank((Object)combineKey, (Object)member);
    }

    public Long zlexcount(String group, String key, String min, String max) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.customZSetOps().count(combineKey, min, max);
    }

    public Long zunionstore(String group, String dstkey, String[] sets) {
        Long result = null;
        if (sets != null && sets.length > 0) {
            String dstCombineKey = this.combineKey(group, dstkey);
            String[] combineKeys = this.combineKeys(group, sets);
            result = this.stringRedisTemplate.opsForZSet().unionAndStore((Object)combineKeys[0], Arrays.asList(combineKeys), (Object)dstCombineKey);
        }
        return result;
    }

    public Long zremrangeByRank(String group, String key, long start, long end) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForZSet().removeRange((Object)combineKey, start, end);
    }

    public Long zinterstore(String group, String dstkey, String[] sets) {
        Long result = null;
        if (sets != null && sets.length > 0) {
            String dstCombineKey = this.combineKey(group, dstkey);
            String[] combineKeys = this.combineKeys(group, sets);
            result = this.stringRedisTemplate.opsForZSet().intersectAndStore((Object)combineKeys[0], Arrays.asList(combineKeys), (Object)dstCombineKey);
        }
        return result;
    }

    public Set<String> zrangeByScore(String group, String key, double min, double max) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForZSet().rangeByScore((Object)combineKey, min, max);
    }

    public Set<String> zrangeByScore(String group, String key, String min, String max) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.customZSetOps().zrangeByScore(combineKey, min, max);
    }

    public Set<String> zrangeByScore(String group, String key, double min, double max, int offset, int count) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForZSet().rangeByScore((Object)combineKey, min, max, (long)offset, (long)count);
    }

    public Set<String> zrangeByScore(String group, String key, String min, String max, int offset, int count) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.customZSetOps().zrangeByScore(combineKey, min, max, offset, count);
    }

    public Map<Long, String> zrangeByScoreWithScores(String group, String key, double min, double max) {
        String combineKey = this.combineKey(group, key);
        Set set = this.stringRedisTemplate.opsForZSet().rangeByScoreWithScores((Object)combineKey, min, max);
        return this.getLongStringMap(set);
    }

    protected Map<Long, String> getLongStringMap(Set<ZSetOperations.TypedTuple<String>> set) {
        if (!CollectionUtils.isEmpty(set)) {
            HashMap map = new HashMap(set.size());
            set.parallelStream().forEach(typedTuple -> {
                String cfr_ignored_0 = (String)map.put(typedTuple.getScore() == null ? null : Long.valueOf(typedTuple.getScore().longValue()), typedTuple.getValue());
            });
        }
        return new HashMap<Long, String>(0);
    }

    public Map<Long, String> zrangeByScoreWithScores(String group, String key, String min, String max) {
        String combineKey = this.combineKey(group, key);
        Set<ZSetOperations.TypedTuple<String>> set = this.stringRedisTemplate.customZSetOps().rangeByScoreWithScores(combineKey, min, max);
        return this.getLongStringMap(set);
    }

    public Map<Long, String> zrangeByScoreWithScores(String group, String key, double min, double max, int offset, int count) {
        String combineKey = this.combineKey(group, key);
        Set set = this.stringRedisTemplate.opsForZSet().rangeByScoreWithScores((Object)combineKey, min, max, (long)offset, (long)count);
        return this.getLongStringMap(set);
    }

    public Map<Long, String> zrangeByScoreWithScores(String group, String key, String min, String max, int offset, int count) {
        String combineKey = this.combineKey(group, key);
        Set<ZSetOperations.TypedTuple<String>> set = this.stringRedisTemplate.customZSetOps().rangeByScoreWithScores(combineKey, min, max, offset, count);
        return this.getLongStringMap(set);
    }

    public Long zremrangeByScore(String group, String key, double start, double end) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForZSet().removeRangeByScore((Object)combineKey, start, end);
    }

    public Long zremrangeByScore(String group, String key, String start, String end) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.customZSetOps().removeRangeByScore(combineKey, start, end);
    }

    public Set<String> zrangeByLex(String group, String key, String min, String max) {
        String combineKey = this.combineKey(group, key);
        RedisZSetCommands.Range range = new RedisZSetCommands.Range();
        range.gte((Object)min);
        range.lt((Object)max);
        return this.stringRedisTemplate.opsForZSet().rangeByLex((Object)combineKey, range);
    }

    public Set<String> zrangeByLex(String group, String key, String min, String max, int offset, int count) {
        String combineKey = this.combineKey(group, key);
        RedisZSetCommands.Range range = new RedisZSetCommands.Range();
        range.gte((Object)min);
        range.lt((Object)max);
        RedisZSetCommands.Limit limit = new RedisZSetCommands.Limit();
        limit.offset(offset);
        limit.count(count);
        return this.stringRedisTemplate.opsForZSet().rangeByLex((Object)combineKey, range, limit);
    }

    public Long zremrangeByLex(String group, String key, String min, String max) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.customZSetOps().removeRange(combineKey, min, max);
    }

    public void psubscribe(final IRedisSubProcessor<String> processor, String[] patterns) {
        byte[][] p = this.serializeKeys(patterns);
        this.stringRedisTemplate.execute(connection -> {
            MessageListener listener = new MessageListener(){

                public void onMessage(Message message, byte[] pattern) {
                    String convertedChannel = (String)RedisCacheServiceImpl.this.stringRedisTemplate.getStringSerializer().deserialize(pattern);
                    String convertedMessage = (String)RedisCacheServiceImpl.this.stringRedisTemplate.getStringSerializer().deserialize(message.getBody());
                    processor.process(convertedChannel, (Object)convertedMessage);
                }
            };
            connection.pSubscribe(listener, p);
            return null;
        }, true);
    }

    private byte[][] serializeKeys(String ... keys) {
        if (keys == null) {
            return new byte[0][];
        }
        byte[][] ret = new byte[keys.length][];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.stringRedisTemplate.getStringSerializer().serialize((Object)keys[i]);
        }
        return ret;
    }

    public Long geoadd(String group, String key, double longitude, double latitude, String member) {
        String combineKey = this.combineKey(group, key);
        Point point = new Point(longitude, latitude);
        return this.stringRedisTemplate.opsForGeo().add((Object)combineKey, point, (Object)member);
    }

    public Long geoadd(String group, String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        Long result = null;
        String combineKey = this.combineKey(group, key);
        if (!CollectionUtils.isEmpty(memberCoordinateMap)) {
            Map<String, Point> map = this.geoCoordinateToPointMap(memberCoordinateMap);
            result = this.stringRedisTemplate.opsForGeo().add((Object)combineKey, map);
        }
        return result;
    }

    protected Map<String, Point> geoCoordinateToPointMap(Map<String, GeoCoordinate> memberCoordinateMap) {
        HashMap<String, Point> map = new HashMap<String, Point>(memberCoordinateMap.size());
        memberCoordinateMap.entrySet().stream().filter(m -> m.getValue() != null).forEach(m -> {
            Point point = new Point(((GeoCoordinate)m.getValue()).getLongitude(), ((GeoCoordinate)m.getValue()).getLatitude());
            map.put((String)m.getKey(), point);
        });
        return map;
    }

    public Double geodist(String group, String key, String member1, String member2) {
        String combineKey = this.combineKey(group, key);
        Distance distance = this.stringRedisTemplate.opsForGeo().distance((Object)combineKey, (Object)member1, (Object)member2);
        return distance == null ? 0.0 : distance.getValue();
    }

    public Double geodist(String group, String key, String member1, String member2, GeoUnit unit) {
        Metrics metrics = this.getMetrics(unit);
        String combineKey = this.combineKey(group, key);
        Distance distance = this.stringRedisTemplate.opsForGeo().distance((Object)combineKey, (Object)member1, (Object)member2, (Metric)metrics);
        return distance == null ? 0.0 : distance.getValue();
    }

    private Metrics getMetrics(GeoUnit unit) {
        Metrics metrics = unit.equals((Object)GeoUnit.KM) ? Metrics.KILOMETERS : (unit.equals((Object)GeoUnit.M) ? Metrics.MILES : Metrics.NEUTRAL);
        return metrics;
    }

    public List<String> geohash(String group, String key, String[] members) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForGeo().hash((Object)combineKey, (Object[])members);
    }

    public List<GeoCoordinate> geopos(String group, String key, String[] members) {
        String combineKey = this.combineKey(group, key);
        List list = this.stringRedisTemplate.opsForGeo().position((Object)combineKey, (Object[])members);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return list.parallelStream().map(point -> new GeoCoordinate(point.getX(), point.getY())).collect(Collectors.toList());
        }
        return new ArrayList<GeoCoordinate>(0);
    }

    public List<GeoRadiusResponse> georadius(String group, String key, double longitude, double latitude, double radius, GeoUnit unit) {
        String combineKey = this.combineKey(group, key);
        Point point = new Point(longitude, latitude);
        Metrics metrics = this.getMetrics(unit);
        Distance distance = new Distance(radius, (Metric)metrics);
        Circle circle = new Circle(point, distance);
        GeoResults results = this.stringRedisTemplate.opsForGeo().radius((Object)combineKey, circle);
        return this.getGeoRadiusResponses((GeoResults<RedisGeoCommands.GeoLocation<String>>)results);
    }

    private List<GeoRadiusResponse> getGeoRadiusResponses(GeoResults<RedisGeoCommands.GeoLocation<String>> results) {
        if (results != null && !CollectionUtils.isEmpty((Collection)results.getContent())) {
            List list = results.getContent();
            return list.parallelStream().map(geoResult -> {
                Point p = ((RedisGeoCommands.GeoLocation)geoResult.getContent()).getPoint();
                GeoCoordinate geoCoordinate = null;
                if (p != null) {
                    geoCoordinate = new GeoCoordinate(p.getX(), p.getY());
                }
                GeoRadiusResponse radiusResponse = new GeoRadiusResponse((String)((RedisGeoCommands.GeoLocation)geoResult.getContent()).getName());
                radiusResponse.setCoordinate(geoCoordinate);
                radiusResponse.setDistance(geoResult.getDistance().getValue());
                return radiusResponse;
            }).collect(Collectors.toList());
        }
        return new ArrayList<GeoRadiusResponse>(0);
    }

    public List<GeoRadiusResponse> georadius(String group, String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam geoRadiusParam) {
        String combineKey = this.combineKey(group, key);
        Point point = new Point(longitude, latitude);
        Metrics metrics = this.getMetrics(unit);
        Distance distance = new Distance(radius, (Metric)metrics);
        Circle circle = new Circle(point, distance);
        RedisGeoCommands.GeoRadiusCommandArgs geoRadiusCommandArgs = GeoRadiusParamToCommand.geoRadiusCommandArgs(geoRadiusParam);
        GeoResults results = this.stringRedisTemplate.opsForGeo().radius((Object)combineKey, circle, geoRadiusCommandArgs);
        return this.getGeoRadiusResponses((GeoResults<RedisGeoCommands.GeoLocation<String>>)results);
    }

    public List<GeoRadiusResponse> georadiusByMember(String group, String key, String member, double radius, GeoUnit unit) {
        String combineKey = this.combineKey(group, key);
        Metrics metrics = this.getMetrics(unit);
        Distance distance = new Distance(radius, (Metric)metrics);
        GeoResults results = this.stringRedisTemplate.opsForGeo().radius((Object)combineKey, (Object)member, distance);
        return this.getGeoRadiusResponses((GeoResults<RedisGeoCommands.GeoLocation<String>>)results);
    }

    public Long expireAt(String group, String key, long unixTime) {
        String combineKey = this.combineKey(group, key);
        Boolean result = this.stringRedisTemplate.expireAt(combineKey, new Date(unixTime));
        return result != null && result != false ? 1L : 0L;
    }

    public List<String> sort(String group, String key) {
        String combineKey = this.combineKey(group, key);
        SortQuery sortQuery = SortQueryBuilder.sort((Object)combineKey).build();
        return this.stringRedisTemplate.sort(sortQuery);
    }

    public Long sortWithStoreKey(String group, String key, String dstkey) {
        String combineKey = this.combineKey(group, key);
        String dstCombineKey = this.combineKey(group, dstkey);
        SortQuery sortQuery = SortQueryBuilder.sort((Object)combineKey).build();
        return this.stringRedisTemplate.sort(sortQuery, dstCombineKey);
    }

    public boolean setCache(String group, String key, Object value, int seconds) {
        String combineKey = this.combineKey(group, key);
        if (seconds == 0) {
            this.stringRedisTemplate.opsForValue().set((Object)combineKey, (Object)JacksonUtil.toJson((Object)value));
        } else {
            this.stringRedisTemplate.opsForValue().set((Object)combineKey, (Object)JacksonUtil.toJson((Object)value), (long)seconds, TimeUnit.SECONDS);
        }
        return true;
    }

    public boolean setPersistCache(String group, String key, Object value) {
        String combineKey = this.combineKey(group, key);
        this.stringRedisTemplate.persist(combineKey);
        this.stringRedisTemplate.opsForValue().set((Object)combineKey, (Object)JacksonUtil.toJson((Object)value));
        return true;
    }

    public <T> T getCache(String group, String key, Class<T> clz) {
        String combineKey = this.combineKey(group, key);
        String json = (String)this.stringRedisTemplate.opsForValue().get((Object)combineKey);
        return (T)this.jsonToObj(json, clz);
    }

    public <T> T getCache(String group, String key, TypeReference<T> clz) {
        String combineKey = this.combineKey(group, key);
        String json = (String)this.stringRedisTemplate.opsForValue().get((Object)combineKey);
        return (T)this.stringToObject(json, clz);
    }

    public boolean delCache(String group, String key) {
        String combineKey = this.combineKey(group, key);
        Boolean result = this.stringRedisTemplate.delete(combineKey);
        return result == null ? false : result;
    }

    public Set<String> delCacheByPattern(String group, String pattern) {
        String combineKey = this.combineKey(group, pattern);
        Set keys = this.stringRedisTemplate.keys(combineKey);
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            this.stringRedisTemplate.delete(keys);
        }
        return keys;
    }

    public boolean delCache(String group, List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return false;
        }
        List combineKeys = this.combineKeys(group, keys);
        this.stringRedisTemplate.delete(combineKeys);
        return true;
    }

    public Long incrByWithException(String group, String key, long increment, long seconds) {
        Long incr;
        String combineKey = this.combineKey(group, key);
        try {
            incr = this.stringRedisTemplate.opsForValue().increment((Object)combineKey, increment);
            if (seconds != 0L) {
                this.expire(group, key, seconds);
            }
        }
        catch (Exception e) {
            logger.error("incr\u7f13\u5b58\u51fa\u9519: key={}", (Object)key, (Object)e);
            throw new RuntimeException("incr\u7f13\u5b58\u51fa\u9519: key=" + key, e);
        }
        return incr;
    }

    public Double incrByWithException(String group, String key, double increment, long seconds) {
        Double incr;
        String combineKey = this.combineKey(group, key);
        try {
            incr = this.stringRedisTemplate.opsForValue().increment((Object)combineKey, increment);
            if (seconds != 0L) {
                this.expire(group, key, seconds);
            }
        }
        catch (Exception e) {
            logger.error("incr\u7f13\u5b58\u51fa\u9519: key={}", (Object)key, (Object)e);
            throw new RuntimeException("incr\u7f13\u5b58\u51fa\u9519: key=" + key, e);
        }
        return incr;
    }

    public <T> void lpush(String group, String key, List<T> value, int seconds) {
        String combineKey = this.combineKey(group, key);
        if (!CollectionUtils.isEmpty(value)) {
            this.stringRedisTemplate.delete(combineKey);
            Object[] obj = this.listToArray(value);
            this.stringRedisTemplate.opsForList().leftPushAll((Object)combineKey, obj);
            if (seconds != 0) {
                this.expire(group, key, seconds);
            }
        }
    }

    public <T> void rpush(String group, String key, List<T> value, int seconds) {
        String combineKey = this.combineKey(group, key);
        if (!CollectionUtils.isEmpty(value)) {
            this.stringRedisTemplate.delete(combineKey);
            Object[] obj = this.listToArray(value);
            this.stringRedisTemplate.opsForList().rightPushAll((Object)combineKey, obj);
            if (seconds != 0) {
                this.expire(group, key, seconds);
            }
        }
    }

    public <T> List<T> mget(String group, String[] keys, Class<T> clazz) {
        String[] combineKeys = this.combineKeys(group, keys);
        List values = this.stringRedisTemplate.opsForValue().multiGet(Arrays.asList(combineKeys));
        return this.stringToObjects(values, clazz);
    }

    public <T> List<T> mget(String group, String[] keys, TypeReference<T> clazz) {
        String[] combineKeys = this.combineKeys(group, keys);
        List values = this.stringRedisTemplate.opsForValue().multiGet(Arrays.asList(combineKeys));
        return this.stringToObjects(values, clazz);
    }

    public <T> List<T> getList(String group, String key, Integer from, Integer to, Class<T> clazz) {
        String combineKey = this.combineKey(group, key);
        List list = this.stringRedisTemplate.opsForList().range((Object)combineKey, (long)from.intValue(), (long)to.intValue());
        return this.stringToObjects(list, clazz);
    }

    public <T> void hset(String group, String key, String field, T value, int seconds) {
        String combineKey = this.combineKey(group, key);
        this.stringRedisTemplate.opsForHash().put((Object)combineKey, (Object)field, (Object)JacksonUtil.toJson(value));
        if (seconds != 0) {
            this.expire(group, key, seconds);
        }
    }

    public <T> T hget(String group, String key, String field, Class<T> clz) {
        Object value = null;
        String combineKey = this.combineKey(group, key);
        Object json = this.stringRedisTemplate.opsForHash().get((Object)combineKey, (Object)field);
        if (json != null) {
            value = JacksonUtil.readValue((String)json.toString(), clz);
        }
        return (T)value;
    }

    public <T> List<T> hget(String group, String key, String field, TypeReference<List<T>> typeReference) {
        List value = null;
        String combineKey = this.combineKey(group, key);
        Object json = this.stringRedisTemplate.opsForHash().get((Object)combineKey, (Object)field);
        if (json != null) {
            value = (List)JacksonUtil.readValue((String)json.toString(), typeReference);
        }
        return value;
    }

    public <K, V> Map<K, V> hgetMap(String group, String key, String field, TypeReference<Map<K, V>> typeReference) {
        Map value = null;
        String combineKey = this.combineKey(group, key);
        Object json = this.stringRedisTemplate.opsForHash().get((Object)combineKey, (Object)field);
        if (json != null) {
            value = (Map)JacksonUtil.readValue((String)json.toString(), typeReference);
        }
        return value;
    }

    public boolean hdel(String group, String key, String[] field) {
        String combineKey = this.combineKey(group, key);
        Long result = this.stringRedisTemplate.opsForHash().delete((Object)combineKey, (Object[])field);
        return result > 0L;
    }

    public Long hincrByWithException(String group, String key, String field, Long value) {
        Long incr;
        String combineKey = this.combineKey(group, key);
        try {
            incr = this.stringRedisTemplate.opsForHash().increment((Object)combineKey, (Object)field, value.longValue());
        }
        catch (Exception e) {
            logger.error("hincr\u7f13\u5b58\u51fa\u9519: key={}", (Object)key, (Object)e);
            throw new RuntimeException("hincr\u7f13\u5b58\u51fa\u9519: key=" + key, e);
        }
        return incr;
    }

    public Double hincrByWithException(String group, String key, String field, Double value) {
        Double incr;
        String combineKey = this.combineKey(group, key);
        try {
            incr = this.stringRedisTemplate.opsForHash().increment((Object)combineKey, (Object)field, value.doubleValue());
        }
        catch (Exception e) {
            logger.error("hincr\u7f13\u5b58\u51fa\u9519: key={}", (Object)key, (Object)e);
            throw new RuntimeException("hincr\u7f13\u5b58\u51fa\u9519: key=" + key, e);
        }
        return incr;
    }

    public boolean expire(String group, String key, int seconds) {
        if (seconds != 0) {
            String combineKey = this.combineKey(group, key);
            Boolean result = this.stringRedisTemplate.expire(combineKey, seconds, TimeUnit.SECONDS);
            return result == null ? false : result;
        }
        logger.warn("expire\u4e0d\u652f\u6301\u8fc7\u671f\u65f6\u95f4\u4e3a0\uff0c\u5982\u679c\u9700\u8981\u5220\u9664\u7f13\u5b58\uff0c\u8bf7\u663e\u5f0f\u8c03\u7528\u5220\u9664\u7f13\u5b58\u7684\u65b9\u6cd5\uff01");
        return false;
    }

    public boolean expire(String group, String key, long seconds) {
        if (seconds != 0L) {
            String combineKey = this.combineKey(group, key);
            Boolean result = this.stringRedisTemplate.expire(combineKey, seconds, TimeUnit.SECONDS);
            return result == null ? false : result;
        }
        logger.warn("expire\u4e0d\u652f\u6301\u8fc7\u671f\u65f6\u95f4\u4e3a0\uff0c\u5982\u679c\u9700\u8981\u5220\u9664\u7f13\u5b58\uff0c\u8bf7\u663e\u5f0f\u8c03\u7528\u5220\u9664\u7f13\u5b58\u7684\u65b9\u6cd5\uff01");
        return false;
    }

    public Set<String> getKeys(String group, String pattern) {
        String combineKey = this.combineKey(group, pattern);
        return this.stringRedisTemplate.keys(combineKey);
    }

    public Long zadd(String group, String key, Long score, String member, int seconds) {
        String combineKey = this.combineKey(group, key);
        Boolean result = this.stringRedisTemplate.opsForZSet().add((Object)combineKey, (Object)member, (double)score.longValue());
        if (seconds != 0) {
            this.expire(group, key, seconds);
        }
        return result != null && result != false ? 1L : 0L;
    }

    public Long zadd(String group, String key, Map<String, Long> scoreMembers, int seconds) {
        String combineKey = this.combineKey(group, key);
        Long result = null;
        if (!CollectionUtils.isEmpty(scoreMembers)) {
            HashSet tuples = new HashSet();
            scoreMembers.entrySet().forEach(entry -> {
                DefaultTypedTuple objectTypedTuple = new DefaultTypedTuple(entry.getKey(), Double.valueOf(((Long)entry.getValue()).doubleValue()));
                tuples.add(objectTypedTuple);
            });
            result = this.stringRedisTemplate.opsForZSet().add((Object)combineKey, tuples);
            if (seconds != 0) {
                this.expire(group, key, seconds);
            }
        }
        return result;
    }

    public Set<String> zrange(String group, String key, Long start, Long end) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForZSet().range((Object)combineKey, start.longValue(), end.longValue());
    }

    public Map<Long, String> zrangeWithScores(String group, String key, Long start, Long end) {
        String combineKey = this.combineKey(group, key);
        Set set = this.stringRedisTemplate.opsForZSet().rangeByScoreWithScores((Object)combineKey, (double)start.longValue(), (double)end.longValue());
        return this.getLongStringMap(set);
    }

    public Set<String> zrevrange(String group, String key, Long start, Long end) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForZSet().reverseRange((Object)combineKey, start.longValue(), end.longValue());
    }

    public Map<Long, String> zrevrangeWithScores(String group, String key, Long start, Long end) {
        String combineKey = this.combineKey(group, key);
        Set set = this.stringRedisTemplate.opsForZSet().reverseRangeByScoreWithScores((Object)combineKey, (double)start.longValue(), (double)end.longValue());
        return this.getLongStringMap(set);
    }

    public Long zrem(String group, String key, String member) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForZSet().remove((Object)combineKey, new Object[]{member});
    }

    public Long zrem(String group, String key, List<String> members) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForZSet().remove((Object)combineKey, members.toArray());
    }

    public Long zcard(String group, String key) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForZSet().size((Object)combineKey);
    }

    public Long zscore(String group, String key, String members) {
        String combineKey = this.combineKey(group, key);
        Double result = this.stringRedisTemplate.opsForZSet().score((Object)combineKey, (Object)members);
        return result == null ? null : Long.valueOf(result.longValue());
    }

    public Long zcount(String group, String key, Long min, Long max) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForZSet().count((Object)combineKey, (double)min.longValue(), (double)max.longValue());
    }

    public Long zcount(String group, String key, String min, String max) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.customZSetOps().count(combineKey, min, max);
    }

    public ScanResult<Tuple> zscan(String group, String key, String cursor) {
        String combineKey = this.combineKey(group, key);
        ScanOptions scanOptions = ScanOptions.scanOptions().match(cursor).build();
        Cursor tupleCursor = this.stringRedisTemplate.opsForZSet().scan((Object)combineKey, scanOptions);
        ScanResult scanResult = new ScanResult();
        scanResult.setCurosr(Long.valueOf(tupleCursor.getCursorId()));
        ArrayList<Tuple> tupleList = new ArrayList<Tuple>();
        while (tupleCursor.hasNext()) {
            ZSetOperations.TypedTuple typedTuple = (ZSetOperations.TypedTuple)tupleCursor.next();
            Tuple tuple = new Tuple(typedTuple.getValue() == null ? "" : typedTuple.getValue().toString(), typedTuple.getScore());
            tupleList.add(tuple);
        }
        scanResult.setResults(tupleList);
        return scanResult;
    }

    public Boolean setIfAbsent(String group, String key, String value) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForValue().setIfAbsent((Object)combineKey, (Object)value);
    }

    public Boolean setIfAbsent(String group, String key, String value, int seconds) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForValue().setIfAbsent((Object)combineKey, (Object)value, (long)seconds, TimeUnit.SECONDS);
    }

    public Boolean setIfAbsent(String group, String key, Object value) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForValue().setIfAbsent((Object)combineKey, (Object)JacksonUtil.toJson((Object)value));
    }

    public Boolean setIfAbsent(String group, String key, Object value, int seconds) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForValue().setIfAbsent((Object)combineKey, (Object)JacksonUtil.toJson((Object)value), (long)seconds, TimeUnit.SECONDS);
    }

    public void multi() {
        this.stringRedisTemplate.multi();
    }

    public void shutdown() {
        this.stringRedisTemplate.closeConnectionPool();
    }

    public void watch(String ... key) {
        this.stringRedisTemplate.watch(Arrays.asList(key));
    }

    public void unwatch() {
        this.stringRedisTemplate.unwatch();
    }

    public Map<String, String> hgetAll(String group, String key) {
        String combineKey = this.combineKey(group, key);
        Map map = this.stringRedisTemplate.opsForHash().entries((Object)combineKey);
        return this.objToStringMap(map);
    }

    public ScanResult<Map.Entry<String, String>> hscan(String group, String key, String cursor) {
        String combineKey = this.combineKey(group, key);
        ScanOptions scanOptions = ScanOptions.scanOptions().match(cursor).build();
        Cursor cursorMap = this.stringRedisTemplate.opsForHash().scan((Object)combineKey, scanOptions);
        ScanResult scanResult = new ScanResult();
        scanResult.setCurosr(Long.valueOf(cursorMap.getCursorId()));
        ArrayList<2> list = new ArrayList<2>();
        while (cursorMap.hasNext()) {
            final Map.Entry entry = (Map.Entry)cursorMap.next();
            Map.Entry<String, String> map = new Map.Entry<String, String>(){

                @Override
                public String getKey() {
                    return entry.getKey().toString();
                }

                @Override
                public String getValue() {
                    return entry.getValue().toString();
                }

                @Override
                public String setValue(String value) {
                    return null;
                }
            };
            list.add(map);
        }
        scanResult.setResults(list);
        return scanResult;
    }

    public List<String> hmget(String group, String key, String[] fields) {
        String combineKey = this.combineKey(group, key);
        List values = this.stringRedisTemplate.opsForHash().multiGet((Object)combineKey, Arrays.asList(fields));
        return this.objToString(values);
    }

    public <T> Map<String, T> hmget(String group, String key, String[] fields, Class<T> clazz) {
        List<String> content = this.hmget(group, key, fields);
        return this.stringToMap(fields, content, clazz);
    }

    public <T> Map<String, List<T>> hmget(String group, String key, String[] fields, TypeReference<List<T>> typeReference) {
        List<String> content = this.hmget(group, key, fields);
        return this.listToMap(fields, content, typeReference);
    }

    public Set<String> hkeys(String group, String key) {
        String combineKey = this.combineKey(group, key);
        Set value = this.stringRedisTemplate.opsForHash().keys((Object)combineKey);
        return this.objToString(value);
    }

    public long getToLiveTime(String group, String key) {
        String combineKey = this.combineKey(group, key);
        Long result = this.stringRedisTemplate.getExpire(combineKey);
        return result == null ? 0L : result;
    }

    public boolean mset(String group, Map<String, String> dataMap) {
        Map combineDataMap = this.getCombineDataMap(group, dataMap);
        if (MapUtil.isNotEmpty((Map)combineDataMap)) {
            this.stringRedisTemplate.opsForValue().multiSet(combineDataMap);
            return true;
        }
        return false;
    }

    public boolean hmset(String group, String key, Map<String, String> dataMap) {
        String combineKey = this.combineKey(group, key);
        this.stringRedisTemplate.opsForHash().putAll((Object)combineKey, dataMap);
        return true;
    }

    public void subscribe(String group, String channel, final IRedisSubProcessor<String> processor) {
        String combineChannel = this.combineKey(group, channel);
        byte[] rawChannel = this.stringRedisTemplate.getStringSerializer().serialize((Object)combineChannel);
        this.stringRedisTemplate.execute(connection -> {
            MessageListener listener = new MessageListener(){

                public void onMessage(Message message, byte[] pattern) {
                    String convertedChannel = (String)RedisCacheServiceImpl.this.stringRedisTemplate.getStringSerializer().deserialize(pattern);
                    String convertedMessage = (String)RedisCacheServiceImpl.this.stringRedisTemplate.getStringSerializer().deserialize(message.getBody());
                    processor.process(convertedChannel, (Object)convertedMessage);
                }
            };
            connection.subscribe(listener, (byte[][])new byte[][]{rawChannel});
            return null;
        }, true);
    }

    public void subscribeKeyExpiredEvent(IRedisSubProcessor<String> processor) {
        String channel = String.format("__keyevent@%d__:expired", 0);
        this.subscribe(channel, processor);
    }

    public void publish(String group, String channel, String message) {
        String combineChannel = this.combineKey(group, channel);
        this.stringRedisTemplate.convertAndSend(combineChannel, message);
    }

    public void publish(String channel, String message) {
        this.publish(this.group, channel, message);
    }

    public boolean pfadd(String group, String key, String[] elements) {
        String combineKey = this.combineKey(group, key);
        long result = this.stringRedisTemplate.opsForHyperLogLog().add((Object)combineKey, (Object[])elements);
        return result > 0L;
    }

    public long pfcount(String group, String key) {
        String combineKey = this.combineKey(group, key);
        return this.stringRedisTemplate.opsForHyperLogLog().size((Object[])new String[]{combineKey});
    }

    public long pfcount(String group, String[] keys) {
        Object[] combineKeys = this.combineKeys(group, keys);
        return this.stringRedisTemplate.opsForHyperLogLog().size(combineKeys);
    }

    public boolean pfmerge(String group, String destKey, String[] sourceKeys) {
        String combineDestKey = this.combineKey(group, destKey);
        Object[] combineSourceKeys = this.combineKeys(group, sourceKeys);
        long result = this.stringRedisTemplate.opsForHyperLogLog().union((Object)combineDestKey, combineSourceKeys);
        return result > 0L;
    }

    public <T> T eval(String script, Class<T> resultType, List<String> keys, Object[] args) {
        List combineSourceKeys = this.combineKeys(keys);
        return (T)this.stringRedisTemplate.execute(RedisScript.of((String)script, resultType), combineSourceKeys, args);
    }

    public boolean periodLimiting(String key, int maxCount, int period) {
        String combineKey = this.combineKey(this.group, key);
        long nowTs = System.currentTimeMillis();
        this.stringRedisTemplate.customZSetOps().removeRangeByScore(combineKey, 0.0, nowTs - (long)(period * 1000));
        Long zcard = this.stringRedisTemplate.customZSetOps().zCard(combineKey);
        if (zcard != null && zcard < (long)maxCount) {
            this.stringRedisTemplate.customZSetOps().add(combineKey, UUID.randomUUID().toString(), nowTs);
            this.stringRedisTemplate.expire(combineKey, Duration.ofSeconds(period));
            return true;
        }
        return false;
    }
}

