/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.cache.redis.config;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.huieryun.cache.api.IRedisCacheService;
import com.dtyunxi.huieryun.cache.redis.impl.RedisCacheServiceImpl;
import com.dtyunxi.huieryun.cache.vo.CacheRegistryVo;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.CustomRedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.CustomStringRedisTemplate;

@AutoConfigureBefore(value={org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration.class})
@AutoConfigureAfter(value={CustomRedisAutoConfiguration.class})
@ConditionalOnBean(value={RedisConnectionFactory.class})
public class RedisAutoConfiguration {
    private static final String PROFILE_KEY = "active.profile";
    @Value(value="${spring.profiles.active:dev}")
    private String profile;
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    @Value(value="${spring.application.name:}")
    private String envModule;
    @Value(value="${huieryun.cacheregistryvo.groupName:}")
    private String groupName;

    @Bean
    @ConditionalOnMissingBean(value={CustomStringRedisTemplate.class})
    public CustomStringRedisTemplate customStringRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        return new CustomStringRedisTemplate(redisConnectionFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public IRedisCacheService redisCacheService(CustomStringRedisTemplate stringRedisTemplate, CacheRegistryVo cacheRegistryVo) {
        String pfile = StrUtil.isBlank((CharSequence)this.globalProfile) ? this.profile : this.globalProfile;
        RedisCacheServiceImpl redisCacheService = new RedisCacheServiceImpl(stringRedisTemplate);
        if (StrUtil.isNotBlank((CharSequence)this.groupName)) {
            redisCacheService.setGroup(this.groupName + "-" + pfile);
        } else {
            redisCacheService.setGroup(this.envModule + "-" + pfile);
        }
        redisCacheService.setCacheRegistryVo(cacheRegistryVo);
        return redisCacheService;
    }
}

