/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.cache.redis.config;

import com.dtyunxi.huieryun.cache.vo.CacheRegistryVo;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;

public class RedisFactoryUtils {
    public static LettuceConnectionFactory getConnectionFactory(CacheRegistryVo cacheRegistryVo) {
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxTotal(cacheRegistryVo.getMaxTotal());
        poolConfig.setMaxIdle(cacheRegistryVo.getMaxIdle());
        poolConfig.setMinIdle(1);
        poolConfig.setMaxWaitMillis((long)cacheRegistryVo.getMaxWaitMillis());
        LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder builder = LettucePoolingClientConfiguration.builder().poolConfig(poolConfig);
        if (cacheRegistryVo.isSsl()) {
            builder.useSsl();
        }
        LettuceClientConfiguration clientConfig = builder.build();
        LettuceConnectionFactory connectionFactory = null;
        switch (cacheRegistryVo.getWorkModelEnum()) {
            case CLUSTER: {
                if (cacheRegistryVo.getAddresses() == null) break;
                RedisClusterConfiguration cluster = new RedisClusterConfiguration(Arrays.asList(cacheRegistryVo.getAddresses()));
                cluster.setPassword(RedisPassword.of((String)cacheRegistryVo.getAppSecret()));
                connectionFactory = new LettuceConnectionFactory(cluster, clientConfig);
                break;
            }
            case SENTINEL: {
                if (cacheRegistryVo.getAddresses() == null) break;
                String master = cacheRegistryVo.getAddresses()[0];
                if (!master.startsWith("redis://")) {
                    master = "redis://" + master;
                }
                HashSet<String> sentinelHostAndPorts = new HashSet<String>(cacheRegistryVo.getAddresses().length - 1);
                for (int i = 0; i < cacheRegistryVo.getAddresses().length; ++i) {
                    String address = cacheRegistryVo.getAddresses()[i];
                    if (!address.startsWith("redis://")) {
                        sentinelHostAndPorts.add("redis://" + address);
                        continue;
                    }
                    sentinelHostAndPorts.add(address);
                }
                RedisSentinelConfiguration sentinel = new RedisSentinelConfiguration(master, sentinelHostAndPorts);
                sentinel.setPassword(RedisPassword.of((String)cacheRegistryVo.getAppSecret()));
                if (cacheRegistryVo.getDbIndex() > 0) {
                    sentinel.setDatabase(cacheRegistryVo.getDbIndex());
                }
                connectionFactory = new LettuceConnectionFactory(sentinel, clientConfig);
                break;
            }
            default: {
                RedisStandaloneConfiguration standalone = new RedisStandaloneConfiguration(cacheRegistryVo.getHost(), Integer.valueOf(cacheRegistryVo.getPort()).intValue());
                if (cacheRegistryVo.getDbIndex() > 0) {
                    standalone.setDatabase(cacheRegistryVo.getDbIndex());
                }
                standalone.setPassword(RedisPassword.of((String)cacheRegistryVo.getAppSecret()));
                connectionFactory = new LettuceConnectionFactory(standalone, clientConfig);
            }
        }
        return connectionFactory;
    }
}

