/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.cache.provider;

import com.dtyunxi.huieryun.cache.provider.MemCached;
import com.dtyunxi.huieryun.cache.vo.CacheRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import javax.security.auth.callback.CallbackHandler;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.auth.PlainCallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunMemCache
extends MemCached {
    private static final Logger logger = LoggerFactory.getLogger(MemCached.class);
    private AuthDescriptor ad;

    @Override
    public void init(String group, CacheRegistryVo cacheRegistryVo) {
        super.init(group, cacheRegistryVo);
        this.ad = new AuthDescriptor(new String[]{"PLAIN"}, (CallbackHandler)new PlainCallbackHandler(cacheRegistryVo.getAppId(), cacheRegistryVo.getAppSecret()));
    }

    private MemcachedClient getMemcachedClient() {
        MemcachedClient client = null;
        try {
            client = new MemcachedClient(new ConnectionFactoryBuilder().setProtocol(ConnectionFactoryBuilder.Protocol.BINARY).setAuthDescriptor(this.ad).build(), AddrUtil.getAddresses((String)this.cacheRegistryVo.getAddresses()[0]));
        }
        catch (Exception e) {
            logger.error("\u521b\u5efaMemcached\u7f13\u5b58\u5b9e\u4f8b\u51fa\u9519: {}", (Object)this.cacheRegistryVo, (Object)e);
            throw new BusinessRuntimeException("\u521b\u5efaMemcached\u7f13\u5b58\u5b9e\u4f8b\u51fa\u9519", (Throwable)e);
        }
        return client;
    }
}

