/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.springboot.beans;

import com.dtyunxi.util.PropertiesUtils;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemConfig {
    private static final Logger logger = LoggerFactory.getLogger(SystemConfig.class);
    private static final String CONFIG_FILE_PATH = "common/config/config.properties";
    private static AtomicBoolean isExeced = new AtomicBoolean(false);
    private static Map<String, String> systemConfigMap = new HashMap<String, String>();

    private SystemConfig() {
    }

    public static void loadSystemConfig() {
        if (isExeced.compareAndSet(false, true)) {
            PropertiesUtils propertiesUtils = new PropertiesUtils(CONFIG_FILE_PATH);
            Enumeration<Object> keys = propertiesUtils.getProperties().keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement().toString();
                String value = propertiesUtils.getProperty(key);
                SystemConfig.put(key, value);
            }
        }
    }

    public static void put(String key, String value) {
        systemConfigMap.put(key, value);
    }

    private static String getValue(String key) {
        String value = System.getProperty(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            value = System.getenv(key);
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            value = systemConfigMap.get(key);
        }
        return value;
    }

    public static String getStringValue(String key) {
        return SystemConfig.getValue(key);
    }

    public static String getStringValue(String key, String defaultValue) {
        String value = SystemConfig.getValue(key);
        return value != null ? value : defaultValue;
    }

    public static Integer getIntegerValue(String key) {
        String value = SystemConfig.getValue(key);
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public static Integer getInteger(String key, Integer defaultValue) {
        String value = SystemConfig.getValue(key);
        return value != null ? Integer.valueOf(value) : defaultValue;
    }

    public static Double getDoubleValue(String key) {
        String value = SystemConfig.getValue(key);
        if (value == null) {
            throw new NoSuchElementException();
        }
        return Double.valueOf(value);
    }

    public static Double getDoubleValue(String key, Integer defaultValue) {
        String value = SystemConfig.getValue(key);
        return value != null ? Double.valueOf(value) : (double)defaultValue.intValue();
    }

    public static Boolean getBooleanValue(String key) {
        String value = SystemConfig.getValue(key);
        if (value == null) {
            throw new NoSuchElementException();
        }
        return Boolean.valueOf(value);
    }

    public static Boolean getBooleanValue(String key, boolean defaultValue) {
        String value = SystemConfig.getValue(key);
        return value != null ? Boolean.valueOf(value) : defaultValue;
    }
}

